/* The Actor Polygon class allows you to create geometric
 shapes of any complexity.  A Polygon is basically a collection
 of points that are connected together in a series of lines.

 In fact, a Polygon isn't neccessarily a real polygon unless
 you explicitly make it one.  For instance, to define a
 triangle, you have to include four points, where the last
 one is the same as the first.  Otherwise the polygon won't be
 closed.  */!!

inherit(GraphicsObject, #Polygon, nil, nil, nil);!!

now(class(Polygon));!!

/* Create a new Polygon object in Actor.
  For example, to create a triangle with
  vertices at 0@0, 3@4, and 0@4, you would
  send the message new(Polygon,
  #(0@0 3@4 0@4 0@0)).  */
Def new(self, aColl | aPoly)
{       aPoly := variableNew(self:Behavior, limit(aColl) * 4);
        do(over(0, limit(aColl)),
                { using(idx) putWord(aPoly, x(aColl[idx]), idx * 4);
                                putWord(aPoly, y(aColl[idx]), (idx * 4) + 2)
                });
        ^aPoly;
}!!

now(Polygon);!!

/* Draw the Polygon receiver using the
  specified handle to a display context. */
Def draw(self, hdc)
{ Call Polyline(hdc, self, limit(self)/4);
}!!
