/* General purpose for creating and running modal dialogs.
 Modal dialogs are dialogs which takes control from its
 parent window, and usually require some action on the part
 of the user before work can continue.  For most kinds of modal
 dialogs, a descendant class needs to be defined, but some
 simple dialogs can use this class directly. */  !!

/* inherit(Object, #ModalDialog, #( handle ), nil, nil) */ !!

now(ModalDialogClass) !!

/* Create and run a modal dialog.  This method does not
  return until the dialog is finished. */
Def new(self, resID, parent | theDlg)
{ theDlg := new(self:Behavior);
  setDialog(theDlg);
  ^Call DialogBox(HInstance, resID, handle(parent),
    LpDFunc);
}!!


now(ModalDialog) !!

/* Exit point for a modal dialog.  If Cancel was not
  chosen, wP is passed to the MS-Windows EndDialog
  routine.  If Cancel was chosen, 0 is passed to
  EndDialog.  The value passed is then returned by
  the MS-Windows DialogBox function.  */
 Def WM_COMMAND(self, wp, lp | val)
{
  select
    case wp == IDCANCEL
    is Call EndDialog(handle, 0);
    endCase
  default Call EndDialog(handle, wp);
  endSelect;
  ^0;
}!!

/* By returning a 1 from the INITDIALOG message,
  we are telling MS-Windows to set the input focus to
  first tabstop item. (See MS-Windows Reference 8.3). */
Def WM_INITDIALOG(self, wp, lp)
{  ^1
}!!


/* Return the handle for the dialog. */
 Def handle(self)
{ ^handle;
}!!


/* Set the text for the specified dialog item.  */
Def setItemText(self, item, aStr | hnd, lpStr)
{       lpStr := Call GlobalLock(hnd := asHandle(aStr));
        Call SendDlgItemMessage(handle, item, WM_SETTEXT, 0, lpStr);
        Call GlobalUnlock(hnd)
}!!

/* Return text string for the specified dialog item.  */
Def getItemText(self, item | len, aStr)
{       len := asInt(Call SendDlgItemMessage(handle, item,
                        WM_GETTEXTLENGTH, 0, 0));
        aStr := new(String,len+1);
        Call SendDlgItemMessage(handle, item, WM_GETTEXT, len+1, aStr);
        ^subString(aStr,0,len);
}!!


/* Set the caption text for the dialog window.  */
Def setText(self, aStr | hnd, lpStr)
{       lpStr := Call GlobalLock(hnd := asHandle(aStr));
        Call SetWindowText(handle, lpStr);
        Call GlobalUnlock(hnd);
}!!

/* Return the selected text for a ListBox. */
Def getLBText(self, item | iv, len, aStr)
{       aStr := new(String,30);
        iv := Call SendDlgItemMessage(handle, item, LB_GETCURSEL, 0, 0);
        if asInt(iv) == LBN_ERR
        then ^nil
        else    len := asInt(Call SendDlgItemMessage(handle, item,
                                LB_GETTEXT, iv, aStr));
                if len == LBN_ERR
                then ^nil
                else    ^subString(aStr,0,len);
                endif;
        endif;
}!!

/* Toggle a check button and return the new boolean state. */
 Def toggle(self, id | val)
{
  if Call IsDlgButtonChecked(handle, id) > 0
  then val := 0
  else val := 1
  endif;
  Call CheckDlgButton(handle, id, val);
  ^val == 1
}!!


/* Flash the dialog to signal an error.  */
Def flash(self)
{       Call FlashWindow(handle, 1);
        Call FlashWindow(handle, 0)
}!!

/* Set this dialog to be the current one. */
 Prim  setDialog(self): self!!
