/* Library defines a Windows dynamically-linked library
 module.  All procs must be imported by ordinal. */ !!

inherit(Object, #Library, #(hLib  /* Handle to the library */
name  /* Name of library */
ordinals  /* Table of ordinals */
procs /* Dictionary of external procedures */), 2, nil) !!



now(class(Library));!!

/* Create and return a new Library object.  */
Def new(self)
{	^init(new(self:Behavior));
}!!

#define LFANew 0x3c;
#define NResTab 44;!!

now(Library);!!

/* Set up the procs method dictionary. */
Def init(self)
{ procs := new(MethodDictionary,16);
} !!

/* Build the lookup table of names and
  ordinals from the .EXE module.  */
Def loadOrdinals(self | exe, hdr, len,
  pname, struc)
{ hdr := new(Struct, 64);
  struc := new(Struct, 2);
  ordinals := new(MethodDictionary, 16);
  exe := setName(new(File), name);
  open(exe, 0);
  checkError(exe);
  readInto(hdr, exe);
  /* read old header  */
  moveTo(exe, longAt(hdr, LFANew));
  checkError(exe);
  readInto(hdr, exe);
  /* read new exe header  */
  moveTo(exe, longAt(hdr, NResTab));
  checkError(exe);
  /* we are now positioned to the
    non-resident name table. Format:
    (len byte) MODULE NAME 00 00 (len
    byte) PROC NAME (ordinal)... 00 00
    */
  len := asInt(readChar(exe));
  print(len);
  print(' ');
  move(exe, asLong(len+2));
  /*  skip the module name and nulls */
  loop
  while (len := asInt(readChar(exe))) >
    0
  begin  pname := read(exe, len);
    print(pname);
    readInto(struc, exe);
    add(ordinals, asSymbol(pname),
      asInt(wordAt(struc,0)));
  endLoop;
  close(exe);
} !!


/*  Load the library and look up all
  proc addresses.  NOTE: you must add arg
  descriptors for all procedures that you wish
  to use before calling load. */
Def load(self)
{ loadOrdinals(self);
  hLib := Call
    LoadLibrary(asciiz(name));
  if  hLib < 32
  then  error(self, stackTop(),
    #libLoad);
  endif;
  /* now find addresses of all
    procedures */
  keysDo(procs,
  {using(pr | addr) addr := Call
    GetProcAddress(hLib, ordinals[pr]);
    setAddr(procs[pr], addr);
  });
} !!


/* Add a procedure name and args descriptor.
  Example: add(lib, #doRegression, 0, #(0 1 1 0))  */
Def add(self, sym, ret, args)
{ add(procs, sym, new(Proc));
  setArgs(procs[sym], ret, args);
} !!

/* Free the global memory occupied by
  the library. */
Def free(self)
{ Call FreeLibrary(hLib);
} !!

