/* Struct for communication with DOS via the INT 21H function call.  The
 struct must be set up with register values at the following offsets:
 SI:0 DI:2 AX:4 BX:6 CX:8 DX:10 DS:12 ES:14.   */ !!

inherit(Struct, #DosStruct, nil, 0, 1) !!

now(DosStructClass)!!

/* Create and return a new Struct with enough room
  to hold the 8 registers AX-DX, SI, DI, ES, DS. */
Def new(self)
{ ^variableNew(self:Behavior, 16)
} !!


#define DOS_SI		0
#define DOS_DI		2
#define DOS_AX		4
#define DOS_BX		6
#define DOS_CX		8
#define DOS_DX		10
#define DOS_DS		12
#define DOS_ES		14!!

now(DosStruct)!!

/* Set the DOS function number in the
  byte that will be placed in AH. */
Def setCall(self, fn)
{ putMSB(self, fn, DOS_AX);
} !!


/* Get the standard DOS error return
  code from the last call to DOS. */
Def getError(self)
{ ^getError(Source);
} !!




