/* This class creates and manages the "Dirty Classes" dialog box.
  This is displayed when trying to quit Actor after modifying classes
  and their source files without doing a snapshot. */ !!

inherit(ModalDialog, #DirtyCLD,
#(classes /* The set of classes whose source code has been modified */
 ), nil, nil) !!

now(DirtyCLDClass) !!

/* Create a new dirty classes dialog.  Returns constant value 
  indicating user's choice when dialog is finished. */
Def new(self, resID, parent, clSet | theDlg)
{	setDialog(theDlg := new(self:Behavior));
	theDlg.classes := clSet;
	^Call DialogBox(HInstance, resID, handle(parent), LpDFunc) > 0;
}!!

now(DirtyCLD) !!

/* Initialize the dialog. */
Def WM_INITDIALOG(self, wP, lP | aStr)
{	aStr := new(String, 0);
	do(classes, {using(cl)  aStr := aStr + cl + " "});
	setItemText(self, DCL_LIST, aStr);
	^1
}!!



