/* This class is responsible for creating and managing
 the special edit window for Browser objects.  The edit window
 for Browsers is the part in which you edit method text.  */   !!

inherit(WorkEdit, #BrowEdit, nil, 2, nil) !!

now(BrowEditClass) !!

now(BrowEdit) !!

/* Recalculate xMax for the new size and resize window. */
Def WM_SIZE(self, wp, lp)
{ xMax := asInt(low(lp)) / tmWidth  - 1;
  reform(self);
  moveCaret(self);
  showCaret(self);
  ^0
}!!

/* Format the method string argument into a TextCollection,
  store it in the workText instance variable, and
  return it. */
Def   formatMethod(self, methStr | lex )
{ lex := new(ActorAnalyzer);
  lex.collection := methStr;
  ^workText := formatLines(lex, xMax)
}!!


/* Copy (without formatting) the method string argument into a
  TextCollection, store it in the workText instance variable,
  and return it. */
Def   copyMethod(self, methStr)
{ initWorkText(self);
  insertText(workText, methStr, 0, 0);
  ^workText
}!!

/* Reformat the method. */
 Def   reform(self | aStr)
{ showWaitCurs(self);
  initEditParms(self);
  if size(aStr := makeString(workText)) > 0
  then formatMethod(self, aStr);
    cls(self);
  endif;
  showOldCurs(self);
}!!


/* Insert template string (if-then, loop-endLoop, etc.)
  into the method text, reformat, and return workText. */
 Def   mergeTemplate(self, aString)
{ deleteSelText(self);
  insertText(workText, aString, startLine, startChar);
  reform(self);
  dirty := true;
  ^workText;
}!!

/* Handle auto-indent for Browser. */
 Def  WM_CHAR(self, wP, lP)
{ WM_CHAR(self:EditWindow, wP, lP);
  if wP == 13
  then do(leadingBlanks(workText[startLine-1]),
    {using(i)  WM_CHAR(self:EditWindow, 32, 0);
    } );
  endif;
  ^0;
}!!


