// Whirlwind simulator based on Guy Fedorokow's simulator

$(document).ready(function() {

  var stopped = false; // Indicates execution is stopped.

  var sim = null;
  var status = $("#status")[0];
  var coreImg = null;
  var count = 0;
  function init() {
    sim = new Sim();
    sim.crt = new XwinCrt(sim);
    sim.read_core(coreImg);
    sim.cpu.debug = false;
    sim.traceQuiet = true;
    // sim.cpu.tracePC = true;
    // sim.cpu.traceALU = true;
    sim.cpu.PC = sim.jumpto_addr;
    count = 0;
  }

  // Prevent select on double click
  $("#controls").mousedown(function(e){ e.preventDefault(); });
  

  /**
   * Displays the current processor status.
   */
  function updateStatus() {
    status.innerHTML =
          "      Instruction: " + listing[sim.cpu.PC] +
      "<br>  Program counter:   " + toOctal(sim.cpu.PC, 4) +
      "<br>      Accumulator: " + toOctal(sim.cpu._AC, 6) +
      "<br>       A register: " + toOctal(sim.cpu._AReg, 6) +
      "<br>       B register: " + toOctal(sim.cpu._BReg, 6) +
      "<br>     Drum address: " + sim.cpu.drumClass.drum_unit + ":" + toOctal(sim.cpu.drumClass.group_address, 2) + ":" + toOctal(sim.cpu.drumClass.word_address, 4) +
      "<br>Instruction count: " + count;
  }

  /**
   * Executes some instructions.
   * Loops using setTimeout to give the UI a chance to update.
   * If not stopped, this function schedules itself to run after finishing.
   * @param n - Number of instructions to execute.
   */
  function execute(n = 200) {
    for (var i = 0; i < n; i++) {
      var alarm = sim.cpu.run_cycle();
      count += 1;
      if (alarm != sim.cb.NO_ALARM) {
        alert("alarm: " + alarm);
        stopped = true;
        break;
      }
    }
    updateStatus();
    sim.crt.dimScreen();
    if (!stopped) {
      setTimeout(execute, 10);
    }
  }

  // Wait until core file loaded, then start everything going.
  $.get("bjack.acore", function(contents) {
    coreImg = contents;
    init();
    setTimeout(execute, 10);

    // Set up button callbacks
    $("#stopgo").click(function() {
      if (stopped) {
        // Start running again
        stopped = false;
        $("#stopgo").title="Stop";
        $("#stopgo").alt="Stop";
        $("#stopgo").text("stop");
        setTimeout(execute, 10);
      } else {
        stopped = true;
        $("#stopgo").title="Run";
        $("#stopgo").alt="Run";
        $("#stopgo").text("play_arrow");
      }
    });
    $("#step").click(function() {
      stopped = true;
      $("#stopgo").title="Run";
      $("#stopgo").alt="Run";
      $("#stopgo").text("play_arrow");
      execute(1);
      updateStatus();
    });
    $("#reset").click(function() {
      init();
      updateStatus();
    });
  });
});
