:
# "Alnav.ss", a shell script to display Sub-Network and Public Server
#             information on the screen.

# Copyright 1986 Intel Corporation.

# 03/21/86  gll  Initial entry for iDIS R2.0.

# We do this until the user says to cancel, or we run out of names.

# First, prime the loop.  If there is not at least one name (the invoking
# menu macro should insure this), we abort with an error message.

maxlines=19
maxcols=7
colwid=10
continue=yes
snpsname=${1-absent}
snpslist=$*

if [ "$snpsname" = "absent" ]
then echo "
Alnav.ss: no Sub-Network or Public Server names specified!"
     exit 1
fi

# Enter the loop and process the first Sub-Network or Public Server name.

while [ "$continue" != "c" ]
do

# Clear the screen and indicate a slight pause.

$iDISBIN/Fclrscrn
echo "One moment please ..."

entry=`grep -c ${snpsname} $MASNODEP/etc/drm/subnet`

type=`$iDISBIN/Uselect -s : 1 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

# Get the Ethernet address for this Sub-Network or Public Server.

eaddr=`/iDISboot/Ar $iDISBIN/getnetaddr $snpsname nfs`

if [ "$eaddr" = "" ]
then eaddr="Not found in the nameserver database"
fi

# Get the description.

comment=`$iDISBIN/Uselect -s : 6 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

# Get the UID,GID ranges.

fuid=`$iDISBIN/Uselect -s : 2 0 ${snpsname} < $MASNODEP/etc/drm/subnet`
luid=`$iDISBIN/Uselect -s : 3 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

if [ "$fuid" = "" ]
then uidr="Not Applicable"
else uidr="$fuid - $luid"
fi

fgid=`$iDISBIN/Uselect -s : 4 0 ${snpsname} < $MASNODEP/etc/drm/subnet`
lgid=`$iDISBIN/Uselect -s : 5 0 ${snpsname} < $MASNODEP/etc/drm/subnet`

if [ "$fgid" = "" ]
then gidr="Not Applicable"
else gidr="$fgid - $lgid"
fi

# Now display the information nicely for the administrator.

$iDISBIN/Fclrscrn

if [ $entry -eq 0 ]
then echo "


========================================================================




 *** COULD NOT FIND A SUB-NETWORK OR PUBLIC SERVER NAMED $snpsname ***





========================================================================






"
else echo "


========================================================================

$type Name: $snpsname 

Ethernet Address: $eaddr

$type Description: $comment

User  ID Range: $uidr
Group ID Range: $gidr

========================================================================






"
fi

# Move to the next Sub-Network or Public Server, or quit if there are no more.

set $snpslist
shift
snpsname=${1-absent}
snpslist=$*

if [ "$snpsname" != "absent" ]
then echo "
Press RETURN to display information for \"$snpsname\",
      (\"c\" to cancel the remaining displays)"

     read continue
else continue=c
fi

done
echo
