:
# "Alnapply.ss", a shell script to apply updates pushed down from
#                from the logical network master.

# Copyright 1986 Intel Corporation.

# 05/22/86  gll  Written for iDIS R2.0.
# 06/05/86  gll  Revised to encrypt and change the OpenNET password in
#                the password file too.
# 07/06/86  gll  Corrected filtering of duplicates for /net/cdf so
#                that entires with incorrect service lists will
#                will not be added.

# Make sure we are executing on the master node.

if [ "$MASNODEP" != "`net name`" ]
then exit
fi

# We doublecheck /iDISboot/AUsynch.ss has checked for and found the
# 'ilnaP' flag and marked the directory as busy with the 'ilnaWIP'
# flag before calling us.

updates=$MASNODEP/usr/ilna/netsynch/applied

if [ \( ! -f $updates/ilnaP \) -a \( ! -f $updates/ilnaWIP \) ]
then exit
fi

# Perform the update

for file in `lc $updates`
do
   case $file in newdata) # New entries for /net/data

                          cat $updates/newdata >> $MASNODEP/net/data
                          
                          # Get rid of duplicates, blanks, and sort
                          # The regular expression in the grep below
                          # reads '^[<blank><tab>]*$'

                          grep -v '^[ 	]*$' $MASNODEP/net/data | sort | uniq \
                          >$MASNODEP/net/data$$
                          cp $MASNODEP/net/data$$ $MASNODEP/net/data
                          rm -f $MASNODEP/net/data$$

                          rm -f $updates/newdata
                          ;;

                  newcdf) # New entries for /net/cdf

                          cat $updates/newcdf | sed -e "/^${MASNODE}:/d" \
                            >> $MASNODEP/net/cdf

                          # Get rid of duplicates, blanks, and sort
                          # The regular expression in the grep below
                          # reads '^[<blank><tab>]*$'

                          grep -v '^[ 	]*$' $MASNODEP/net/cdf | sort | uniq \
                          >$MASNODEP/net/cdf$$
                          cp $MASNODEP/net/cdf$$ $MASNODEP/net/cdf
                          rm -f $MASNODEP/net/cdf$$

                          rm -f $updates/newcdf
                          ;;

               newsubnet) # New entries for /etc/drm/subnet

                          cat $updates/newsubnet >> $MASNODEP/etc/drm/subnet

                          # Get rid of duplicates, blanks, and sort
                          # The regular expression in the grep below
                          # reads '^[<blank><tab>]*$'

                          grep -v '^[ 	]*$' $MASNODEP/etc/drm/subnet \
                          | sort | uniq >$MASNODEP/etc/drm/subnet$$
                          cp $MASNODEP/etc/drm/subnet$$ $MASNODEP/etc/drm/subnet
                          rm -f $MASNODEP/etc/drm/subnet$$

                          rm -f $updates/newsubnet
                          ;;

                 newrsrc) # New entries for /etc/drm/finder.rsrc

                          cat $updates/newrsrc >> $MASNODEP/etc/drm/finder.rsrc

                          # Get rid of duplicates, blanks, and sort
                          # The regular expression in the grep below
                          # reads '^[<blank><tab>]*$'

                          grep -v '^[ 	]*$' $MASNODEP/etc/drm/finder.rsrc \
                          | sort | uniq >$MASNODEP/etc/drm/rsrc$$
                          cp $MASNODEP/etc/drm/rsrc$$ \
                          $MASNODEP/etc/drm/finder.rsrc
                          rm -f $MASNODEP/etc/drm/rsrc$$

                          rm -f $updates/newrsrc
                          ;;

               newassign) # New entries for /etc/drm/finder.assign

                          cat $updates/newassign \
                          >> $MASNODEP/etc/drm/finder.assign

                          # Get rid of duplicates, blanks, and sort
                          # The regular expression in the grep below
                          # reads '^[<blank><tab>]*$'

                          grep -v '^[ 	]*$' $MASNODEP/etc/drm/finder.assign \
                          | sort | uniq >$MASNODEP/etc/drm/assign$$
                          cp $MASNODEP/etc/drm/assign$$ \
                          $MASNODEP/etc/drm/finder.assign
                          rm -f $MASNODEP/etc/drm/assign$$

                          rm -f $updates/newassign
                          ;;

                 newmdir) # New network mail directories

                          for dir in `cat $updates/newmdir`
                          do
                             if [ ! -d $MASNODEP/usr/spool/mail/.OpenNET/$dir ]
                             then mkdir $MASNODEP/usr/spool/mail/.OpenNET/$dir
                             fi
                             chmod 777 $MASNODEP/usr/spool/mail/.OpenNET/$dir
                             chgrp 111 $MASNODEP/usr/spool/mail/.OpenNET/$dir
                             chown 111 $MASNODEP/usr/spool/mail/.OpenNET/$dir
                          done
                          rm -f $updates/newmdir
                          ;;

                 newmpwd) # New network mail password

                          # Encrypt the new mail password

                          empwd=`$iDISBIN/Apwgen \`sed -n -e 2p \
                                 $updates/newmpwd\``

                          # Place into the passwd file

                          sed -e "/^OpenNET/c\\
OpenNET:$empwd:111:111:OpenNET Mail:/usr/spool/mail/.OpenNET:/bin/date
" $MASNODEP/etc/passwd > $MASNODEP/tmp/passwd.tmp

                          mv $MASNODEP/tmp/passwd.tmp $MASNODEP/etc/passwd

                          cp $updates/newmpwd \
                          $MASNODEP/usr/spool/mail/.OpenNET/.passwd
                          rm -f $updates/newmpwd
                          ;;

                 newipwd) # New 'ilna' login password

                          sed -e "/^ilna/c\\
`cat $updates/newipwd`
" $MASNODEP/etc/passwd > $MASNODEP/tmp/passwd.tmp
                          mv $MASNODEP/tmp/passwd.tmp $MASNODEP/etc/passwd
                          rm -f $updates/newipwd
                          ;;

                       *) # Ignore other files
                          ;;
   esac
done

# remove both the updates pending and the updates work-in-progress file

rm -f $updates/ilnaP
rm -f $updates/ilnaWIP

# All done!
