:
# "Ailnauniq.ss", a shell script to get a re-entry of the ilna password
#                 and check it against the /etc/passwd file.

# Copyright 1986 Intel Corporation.

# 05/22/86  gll  Written for iDIS R2.0.
# 05/29/86  gll  Added check for login on Logical Network Master.
# 08/05/86  gll  Add message to tell users where to go.

# Make sure we're on the logical network master.

trap "echo nogood;exit 1" 2 3 15

LNM=`$iDISBIN/Uselect -s : 0 6 'The Logical Network Master' \
    < $MASNODEP/etc/drm/subnet`

if [ "$LNM" != "$PHYSYS" ]
then echo -e "
Login on Logical Network Master $LNM to use the Alnatop menu."
     echo nogood
     exit 1
fi

# Save tty settings, or this will not work

o=`stty -g`
stty opost -nl

# Get the password

pw=`$iDISBIN/Areadnoecho "Please re-enter the 'ilna' password: "`

# Reset to the original tty settings

stty $o

# Validate the password

$iDISBIN/Apwverify ilna "$pw"
if [ $? -ne 0 ]
then echo -e "
Sorry, password incorrect."
     echo nogood
     exit 1
else echo $pw
     exit 0
fi
