# "Agrpi.ss", a shell script to build raw transaction for "Initialize Group"

# Copyright 1986 Intel Corporation.

# 03/25/86  gll  Initial entry for iDIS R2.0.  Thanks to Ed Reeder for
#                original code to modify.
# 06/12/86  ugg  validate the home filesystem

# ignore the quit signals
trap "" 1 2 3 15
#
# First, gather up the parameters passed to us on the command line.

Agrp=$1		shift  # Group name
Amgr=$1		shift  # Group manager's login id
Oinfo="$1"	shift  # Group description line 1
Oinfo2="$1"	shift  # Group description line 2
Workarea=$1	shift  # Workarea flag: y = make one, n = don't make one

if [ "$Workarea" = "yes" ]
then Grouptype=iDISGROUP
     HomeNode=$1	shift  # Home node to make workarea on
     HomeFS=$1		shift  # File System on Home node to use
else Grouptype=GROUP
fi

Agid=$1		shift  # Group gid value, if 'automatic', generate gid

# Now gather up some information about the group manager.

if egrep "^$Amgr" $MASNODEP/etc/passwd > /dev/null 2>&1; then
     comment="Manager is $Amgr"

else echo "
The group manager you specified, $Amgr, is not a login id.

Check for spelling errors.  If spelled correctly, you need to
add $Amgr as a user before you can use this login id as a
group manager.
"
     exit 1
fi
#
if [ "$Workarea" = "yes" ]
then
    #  First make sure the $HomeFS filesystem is valid.

    if [ "$OPENNET" = "y" ] ; then
       node=$HomeNode
       reference="the node $node"
       pattern=":file-system:$node:"
       command="$iDISBIN/Uselect -s : 3 2 $node"
       sedpat="$pattern"
       field=2
    else
       node=
       reference="this system"
       pattern=":file-system:"
       command="$iDISBIN/Uselect -s : 3"
       sedpat="$pattern\([^:]*\):"
       field=3
    fi

    if [ `grep ":file-system:" $MASNODEP/etc/drm/finder.rsrc | $command | grep -c "/dev/$HomeFS$" ` = 0 ] ; then
   
         echo " 
The $HomeFS filesystem on $reference is not specified as a resource.
If the $HomeFS filesystem is present on $reference, you need to specify 
it as a 'file-system' type resource before you can define the group's home 
on $HomeFS filesystem.
	"

         if egrep "$pattern" $MASNODEP/etc/drm/finder.rsrc >/dev/null ; then 
            echo "
The following filesystem(s) are currently defined on $reference:
	"

            sed -n -e 's/^\([^:]*\)'$sedpat'\/dev\/\([^:]*\):.*$/'\\$field'/p' $MASNODEP/etc/drm/finder.rsrc | sort | pr -5 -w79 -t
         else
            echo "
No filesystems for $reference are specified in the iDIS resource 
specifications.
	"
         fi

         exit 1
    #
    else
          case $OPENNET in n) Home=/$HomeFS/$Agrp ;;
                           *) Home=//$HomeNode/$HomeFS/$Agrp ;;
          esac
    fi
fi

# Get range of gid values for sub-net, or default to full range.

Startgid=`cat $MASNODEP/etc/drm/baseGID 2> /dev/null`
if [ "$Startgid" = "" ]
then Startgid=0
fi

Lastgid=`cat $MASNODEP/etc/drm/lastGID 2> /dev/null`
if [ "$Lastgid" = "" ]
then Lastgid=32767
fi

# Ensure that this user is unique

/iDISboot/Ar $iDISBIN/Aaddgrpes $Agrp $Grouptype $Agid $Amgr \
                                $Startgid $Lastgid           \
                                "\"$comment\"" $Home > /tmp/Aadd$$
rtn=$?
Agid=`cat /tmp/Aadd$$`; rm -f /tmp/Aadd$$

# Process return code and display appropriate messages.

case $rtn in 0) 
	       # create the mailrc entry for the group
		/iDISboot/Ar "$iDISBIN/Agrpmailrc.ss $Agrp $Amgr"
             ;;

             1) echo "
There is already a group or user named \"$Agrp\".

`egrep \^$Agrp $MASNODEP/etc/passwd`
`egrep \^$Agrp $MASNODEP/etc/group`

You must choose a Group ID that is unique.

This initialization has been rejected."
                exit 1 ;;

             2) echo "
There is another group assigned to group number $Agid.

`$iDISBIN/Uselect -s : 0+ 2 $Agid < $MASNODEP/etc/group`

You must choose one that is unique.

This initialization has been rejected."
                exit 1 ;;

             3) echo "
The master group and/or password file on node $MASNODE could
not be accessed.  You must try again later when connection
is established.

This initialization has been rejected."
                exit 1 ;;

             4) echo "
The Group ID \"$Agrp\" has an invalid format.

The Login ID must be at least 3 characters, beginning with a letter.

This initialization has been rejected."
                exit 1 ;;

             5) echo "
The group number you supplied, $Agid, is not legal.

The number must be between $Startgid and $Lastgid.

This initialization has been rejected."
                exit 1 ;;

             6) echo "
There are no more group numbers available on this system.

Please call your Intel support personnel for instructions.

This initialization has been rejected."
                exit 1 ;;
esac

# add to personnel directory (" is group separator)

case $Oinfo$Oinfo2 in
	"") ;;	# no info was specified
	*)
	    cat <<HERE >> $MASNODEP/etc/Personnel
$Agrp		"
		
		$Oinfo  $Oinfo2
HERE
	;;
esac

# Build the raw transaction file, signal pending
>   /usr/tmp/$LOGINID.idisP
RAW=/usr/tmp/$LOGINID.idisW
cat <<-HERE >> $RAW
	#( Initialize group $Agrp
	Ttype=Init
	Kind=group 
	OPENNET="$OPENNET"
	MASNODE="$MASNODE"
	MASNODEP="$MASNODEP"
	Ausr="$Agrp"
	Auid="800"
	Amgr="$Amgr"
	Aepw="$Grouptype"
	HomeNode="$HomeNode"
	HomeFS="$HomeFS"
	FirstN="$comment"
	MiddleN=""
	LastN=""
	Ophone=""
	Oloc=""
	Oinfo="$Oinfo"
	Oinfo2="$Oinfo2"
	Gid="$Agid"
	Home="$Home"
	Lshell=""
	export Ttype Kind OPENNET MASNODE Ausr Auid Amgr Grouptype HomeNode
	export MiddleN LastN Ophone Oloc Oinfo Oinfo2 Gid Home HomeFS FirstN
	export Aepw Lshell MASNODEP
	#) Initialize group $Agrp
HERE

exit 0
