: 'Copyright 1983, 1985, 1986 Intel Corp.'
: "Adrest.ss <dirname>"
: restore a single directory tree from diskette
# 05/13/86  rhc add PATH for Ar usage

PATH=/bin:/usr/bin	export PATH

: "change DEV=/dev/rdf0 if you use "8" inch diskettes"
DIR=$1
DEV=${DEV=/dev/rdvf0}

: name of the lock file
LOCK=/tmp/rdf0LOCK

if test ! -d $DIR
then
	echo "$DIR is not a drawer (directory)"
	echo "It is possible you have misspelled it, or it will have to be \
created"
	exit 1
fi

: 'PATCHKIT R2.0 -- see if tape installed '
: '		(check for  itp 1  in xenixconf)'
dnam='diskette'
itp=`Uselect -e 0+ 0 lp </sys/conf/xenixconf | Uselect -s p 1`
itp=${itp:=0}
if [ $itp = 1 ] ; then
    resp=x
    while [ .$resp != .t -a .$resp != .d ] ; do
	echo -n "Do you want to restore from tape or from diskette? (t or d)  "
	read resp
	echo
    done
    if [ $resp = t ] ; then
	LOCK=/tmp/itpLOCK
	dnam=tape
    else
	itp=0
    fi
fi


: see if the device is in use
if test -f $LOCK
then
	echo "The lock still exists for the $dnam unit."
	echo -n "It is possible that it is in use; do you want the lock removed?\
 (y or n): "
	read resp
	if test $resp\R != yR
	then
		exit 1
	fi

	rm -f $LOCK
fi

: "remove lock when Adrest.ss exits (normally or abnormally)"
trap "rm -f $LOCK; exit" 0 1 2 3 15

: reserve the device
cp /dev/null $LOCK

: ' PATCHKIT R2.0  Restore from tape '
if [ $itp = 1 ] ; then
    echo
    echo -n "Insert tape then enter y  "
    read resp
    echo
    if [ .$resp != .y ] ; then
        exit 1
    fi
    echo "Do you want to retension the tape?  (Recommended if "
    echo -n "the tape has not been recently used)  (y or n):  "
    read resp
    echo
    STATUS=0
    if [ .$resp = .y ] ; then
	echo "Retensioning tape ..."
	echo
	retension /dev/rmt0
	STATUS=$?
    fi
    if [ $STATUS = 0 ] ; then
	echo "Reloading directory $DIR from tape ..."
	cd $DIR
	tar xvf /dev/rmt0
	STATUS=$?
    fi
else

    echo "You can press the DEL key to cancel this process if need be"
    echo
    echo "Preparing to load files into $DIR"
    echo "Mount the first diskette and enter y"
    read resp
    if test $resp\R != yR
    then
	    exit 1
    fi

    cd $DIR

    resp=y
    until test $resp\R != yR
    do
	    tar xnvf $DEV
	    STATUS=$?
	    echo "Do you have another diskette to restore to $DIR?"
	    echo "If so, mount it and enter y"
	    echo "-or- enter n"
	    read resp
    done
fi

if [ $STATUS -eq 0 ]
then
	echo "$DIR has been successfully restored"
	echo
	echo "Do you wish to review the contents of $DIR to be certain"
	echo "that the proper ownership and attributes have been established?"
	echo -n "Enter (y or n): "
	read resp
	if test $resp\R = yR
	then
		ls -l | more
	fi
fi
