: 'Copyright 1983, 1985 Intel Corp.'
: "Abkup.ss <dirname>"
: backup a single directory tree to diskette

: "change DEV=/dev/rdf0 if you use 8 inch diskettes"
# 05/13/86  rhc add PATH for Ar usage

PATH=/bin:/usr/bin	export PATH
DIR=$1
DEV=${DEV=/dev/rdvf0}
BLKSIZE=10
DEVSIZE=360
if [ "$DEV" = "/dev/rdf0" ]
then
   BLKSIZE=20
   DEVSIZE=1200
fi

: name of the lock file
LOCK=/tmp/rdf0LOCK

if test ! -d $DIR
then
	echo "$DIR is not a drawer (directory)"
	exit 1
fi

: 'PATCHKIT R2.0 -- see if tape installed '
: '		(check for  itp 1  in xenixconf)'
dnam='diskette'
itp=`Uselect -e 0+ 0 itp </sys/conf/xenixconf | Uselect -s p 1`
itp=${itp:=0}
if [ $itp = 1 ] ; then
    resp=x
    while [ .$resp != .t -a .$resp != .d ] ; do
	echo -n "Do you want to backup to tape or to diskette? (t or d)  "
	read resp
	echo
    done
    if [ $resp = t ] ; then
	LOCK=/tmp/itpLOCK
	dnam=tape
    else
	itp=0
    fi
fi

: see if the device is in use
if test -f $LOCK
then
	echo "The lock still exists for the $dnam unit."
	echo -n "It is possible that it is in use; do you want the lock removed?\
 (y or n): "
	read resp
	if test $resp\R != yR
	then
		exit 1
	fi

	rm -f $LOCK
fi

: "remove lock when Abkup.ss exits (normally or abnormally)"
trap "rm -f $LOCK; exit" 0 1 2 3 15

: reserve the device
cp /dev/null $LOCK

: ' PATCHKIT R2.0  Backup to tape '
if [ $itp = 1 ] ; then
    echo
    echo -n "Insert tape then enter y  "
    read resp
    echo
    if [ .$resp != .y ] ; then
        exit 1
    fi
    echo "Do you want to retension the tape?  (Recommended if "
    echo -n "the tape has not been recently used)  (y or n):  "
    read resp
    echo
    rc=0
    if [ .$resp = .y ] ; then
	echo "Retensioning tape ..."
	echo
	retension /dev/rmt0
	rc=$?
    fi
    if [ $rc = 0 ] ; then
	echo "Backing up directory $DIR to tape ..."
	cd $DIR
	tar cvbf 60 /dev/rmt0 .
	rc=$?
    fi
    if [ $rc = 0 ] ; then
	echo "$DIR has been successfully backed up"
    fi
    exit $rc
fi

echo "You can press the DEL key to cancel this process if need be"
echo
echo "Do you want an estimate of the number of diskettes you will need?"
echo -n "(y or n): "
read resp
if test $resp\R = yR
then
	echo "Estimating the number of 1024-byte blocks to be written"
	du -s $DIR
	echo "Your diskettes will hold approximately $DEVSIZE blocks each"
fi
echo
echo "Mount the first diskette, be sure it is write enabled"
echo 
echo -n "Are the diskette(s) already formatted? (y or n): "
read resp
if test $resp\R = nR
then
	resp=y
	until test $resp\R != yR
	do
		echo "Formatting the diskette"
		/etc/format $DEV
		echo "Do you have another diskette to format?"
		echo "Mount next diskette to format (write enabled) and enter y"
		echo "-or- Enter n to continue backup"
		read resp
	done
	echo "Mount first backup diskette and enter y"
	read resp
	if test $resp\R != yR
	then
		exit 1
	fi
fi

: backup the requested directory
cd $DIR
echo "$DIR   may require more than 1 diskette:"
echo "If asked, mount the next one and enter RETURN"

tar -cvnfbk $DEV $BLKSIZE $DEVSIZE .
if test $? = 0
then
	echo "$DIR has been successfully backed up"
fi
