# 'prepares to restore a unit from a backup archive'
# Copyright 1986 Intel Corporation.
cd /usr/tmp
TEMPFILE=$1
filename=$2
TARTVF=TMPTAR$$
trap "rm -f $TARTVF*; exit" 0 1 2 3 15
curtype=`Uselect -s : 1 0 $CURDEV < /etc/drm/finder.rsrc`
blocking="`Uselect -s : 1 0 $curtype < /etc/drm/finder.usage | tr ';' ' '`"
device=`Uselect -s : 3 0 $CURDEV < /etc/drm/finder.rsrc`
if [ "$OPENNET" = "y" ]; then
	nodename=`Uselect -s : 2 0 $CURDEV < /etc/drm/finder.rsrc`
	devnode=//$nodename
	echo " You are using the $CURDEV device " \
		"on node $nodename"
else
	devnode=""
	echo " You are using the $CURDEV device " 
fi
# name of the lock file
LOCK=$devnode/tmp/$CURDEV

# see if the device is in use
if [ -f $LOCK ] ; then
   set `cat $LOCK`
   menuid=$1
   owner=$2
   case $menuid in
      $MENUID) ;;	# It is us, everything is o.k.
      *)
	  echo "
 It is possible that the $CURDEV drive is in use by someone else.  Our
 information suggests that it is in use by a user whose login ID is $owner.
 It is recommended that you physically examine the drive to determine if it is
 in fact being used.

 You will be given an opportunity to go ahead with this operation.  If you
 do go ahead, and the $CURDEV drive IS in use it is possible that you will
 destroy any data that exists on $owner's media.\n"

	  while :
	  do
	      echo -n " Do you wish to go ahead with this operation (y or n)? "
	      read resp
	      case $resp in
		y*|Y*)	rm -f $LOCK
			break ;;
		n*|N*)	echo " Operation has been canceled."
			exit 1 ;;
		*)	echo "\n Invalid response <$resp>, please respecify"
	      esac
	  done
      ;;
   esac
fi

# remove lock when script exits (abnormally)
# preserve previous trap info.
# if the user exits normally, I want to preserve the lock for the
# next step.
trap "rm -f $LOCK $TARTVF*; trap 0; exit" 1 2 3 15

# reserve the device
echo "$MENUID $LOGINID" > $LOCK
chmod 666 $LOCK

case $curtype in

	5-in-diskette|8-in-diskette)
	echo -n " Please insert the first backup diskette.\n" \
	     	"Press return when ready."
	read x
	again=yes
	seq=0
	while [ "$again" = "yes" ]
	do
		seq=`expr $seq + 1`
		/bin/tar tnf $devnode$device > $TARTVF.$seq 2>/dev/null
		echo -n " Are there more backup diskettes in the set? (y or n) "
		read resp
		if [ "$resp" = "y" ]; then
			again=yes
			echo -n	" Please remove the current diskette and "\
				"insert the next one.\n"\
				"Press return to continue. "
			read x
		else
			again=no
		fi
	done
	;;

	directory)
	echo -n "\n Analyzing your archive.\n"\
		"Please wait ..."
	/bin/tar tf $devnode/$device/$filename >> $TARTVF.1 2>/dev/null
	seq=1
	;;

	streamertape)
	echo -n " Do you want to retension your tape cartridges? (y or n) "
	read resp
	if [ "$resp" = "y" ];then
		Aasavert.ss	
	fi
	echo -n " Ready to begin reading the tape cartridges.\n"
	echo -n " Please insert the first tape cartridge.\n"\
		"Press return when ready. "
	read x
	again=yes
	seq=0
	while [ "$again" = "yes" ]
	do
		seq=`expr $seq + 1`
		if [ "$OPENNET" = "y" ]; then
			pwd=`pwd`
			COMMAND="/iDISboot/Ar /bin/tar tf $device "
			Aaremote.ss "${COMMAND}" $nodename //$PHYSYS/usr/tmp/$TARTVF.$seq
		else
			/bin/tar tf $device > $TARTVF.$seq 2 >/dev/null
		fi
		echo -n "Are there more backup cartridges in the set? (y or n) "
		read resp
		if [ "$resp" = "y" ]; then
			again=yes
			echo -n	"Please remove the current cartridge and " \
				"insert the next one.\n"\
				"Press return to continue. "
			read x
		else
			again=no
		fi
	done
	;;

	9tracktape)
	echo -n " Please insert the first tape reel.\n"\
		"Press return when ready. "
	read x
	again=yes
	seq=0
	while [ "$again" = "yes" ]
	do
		seq=`expr $seq + 1`
		if [ "$OPENNET" = "y" ]; then
			pwd=`pwd`
			COMMAND="/iDISboot/Ar /bin/tar tf $device "
			Aaremote.ss "${COMMAND}" $nodename //$PHYSYS/usr/tmp/$TARTVF.$seq
		else
			/bin/tar tf $device > $TARTVF.$seq 2>/dev/null
		fi
		echo -n "Are there more backup tape reels in the set? (y or n) "
		read resp
		if [ "$resp" = "y" ]; then
			again=yes
			echo -n	"Please remove the current tape reel and " \
				"insert the next one.\n"\
				"Press return to continue. "
			read x
		else
			again=no
		fi
	done
	;;
esac
i=1
while [ $i -le $seq ]
do
	sed -e '/tar: blocksize =/d' <$TARTVF.$i | Aamkinterp $i >> $TEMPFILE
	i=`expr $i + 1`
done
chmod 744 $TEMPFILE
