:
# "Functions.ss", a shell script to display and define user-defined actions

# Copyright 1986 Intel Corporation.

# 08/06/85  gll  Re-entered from memory after losing the original file.
#                Added the ability to display and undefine functions.
#                Added help displays.
#
# 09/12/85  gll  Smoothed out the path to re-define a function.
#
# 02/05/86  gll  Made modifications to prompts and help files per EPS
#                review.  Also made 1-8.mac and func1-8 files invisible.
#                Also handles oddball characters except for \.  If user
#                types in a backslash, the shell input routine will take
#                a following carriage return but not terminate the input.
#                This causes the system to appear to hang.
# 06/25/86  gll  SPRs 126, 127, 135, 136, 139, 140, 147.
#                Added <RETURN> to user prompts where suggested.
#                Changed all executions of Clear.ss to Fclrscrn.
#                Changed action un-define to say not currently defined
#                if there is no definition, to say no longer defined
#                if there is one.  Fixed wording inside of Ufunc.mac.
# 07/16/86  gll  Modified so definitions that contain ";" in the
#                action context will work.
# 07/21/86  gll  Modified to prevent confusion between menu names and
#                selections when cutting selection descriptions out of
#                .mnu files.  Also, SPR 267, modified to split action context
#                containing ';' command delimiters into multiple lines
#                when defining user actions.

# Everything here is placed in a loop

backsl=\\
MORE=y

while [ "$MORE" != "" ]
do

# First, we display the current function definitions and ask if
# any are to be re-defined ...

   FUNCOK=n

   while [ "$FUNCOK" = "n" ]
   do

      $iDISBIN/Fclrscrn

      echo "
`cat $USR/.func*`"

# Request a function number between 1-8, a "?" to display help,
# or "RETURN" to cancel the operation ...

      echo -n "
Make an entry as described below, then press RETURN:

  The number, 1-8, of the user action to be defined,
  A \"?<RETURN>\" to display help, or 
  A \"<RETURN>\" by itself to re-display the menu.

Your entry: "

      read MORE

# The following handles oddball characters

              case $MORE in *[\ \!\@\#\$\%\^\&\*\(\)\_\-\+\=\}\{\|\[\]\'\"\;\:\/\.\>\,\<\`\~]*) MORE=9
              ;;
              esac


      if [ "$MORE" = "" ]

      then exit 1

      else FUNC=$MORE
           MORE=y

# Do not allow the input for function to be just a carriage return
# because it will cause the upcoming range test to fail

           if [ "$FUNC" = "" ]

           then FUNC=0

           fi

# Now perform the range test

           if [ "$FUNC" = "?" ]

           then echo -n "
                      USER DEFINED ACTIONS 1-8

The user defined actions, 1 through 8, are actions defined by you to fit 
your own needs.  The intent is to be able to access frequently used menu
selections quickly, without having to navigate the menu system.

Each user action is defined by entering:

   1.  The number, 1 through 8, of the user action to be defined,

   2.  The name of the menu containing the selection which performs
       the desired action, and

   3.  The name of the selection itself.

You are now being requested to enter the number of the user action you
want to define.

If you do not know the name of the menu and the selection from that menu
which will define one of these user actions, press RETURN to cancel the
operation when you are again asked for the user action number.

Press RETURN to continue ... "

                read resp

           else if [ $FUNC -ge 1 -a $FUNC -le 8 ]
                then FUNCOK=y
                     $iDISBIN/Fclrscrn

                else echo "
Please enter a number between 1 and 8, or RETURN to cancel the operation."
                     sleep 2

                fi

           fi

# We now have a valid function number, lets get the name of the defining
# menu, or a "u" to un-define the function, or a "RETURN" to cancel the
# operation

           MENUOK=n

           while [ "$MENUOK" = "n" -a "$FUNCOK" = "y" ]
           do

              echo -n "
Re-defining user action ${FUNC}.

Make an entry as described below, then press RETURN:

   The name of the menu defining user action ${FUNC},
   A \"u<RETURN>\" to un-do (erase) the definition of user action ${FUNC},
   A \"?<RETURN>\" to display help, or
   A \"<RETURN>\" by itself to cancel the operation

Your entry: "

              read MENU

# The following handles oddball characters

              case $MENU in *[\ \!\@\#\$\%\^\&\*\(\)\_\-\+\=\}\{\|\[\]\'\"\;\:\/\.\>\,\<\`\~]*) MENU=xyzzy
              ;;
              esac

              if [ "$MENU" = "" ]

              then echo "
Operation canceled!
"
                   exit 1
              fi

              if [ "$MENU" = "u" ]

              then MENUOK=y
                   SELECOK=y
                   if egrep "is not defined" $USR/.func$FUNC > /dev/null ; then
                      echo "
User action $FUNC is not currently defined."
                   else
                      cp $iDIS/idis/control/Ufunc.mac $USR/.${FUNC}.mac
                      echo "User action $FUNC is not defined" \
                      > $USR/.func$FUNC
                      echo "
User action $FUNC is no longer defined."
		   fi
                   sleep 2

              else if [ "$MENU" = "?" ]

                   then echo -n "
          THE MENU PORTION OF A USER ACTION DEFINITION
                     
User action $FUNC may be defined by entering the name of an iDIS menu, and
then a selection that is found on that menu.

You are now being asked to enter the name of the menu containing the
selection which you want to equate to user action $FUNC.  Each menu's
name is displayed in the upper right-hand corner of the menu screen
enclosed by parentheses.

Some menus may be disallowed because use of their selections as user
action definitions would result in incorrect operation.

If you do not know the name of the menu containing the selection you
want to define as user action $FUNC, you should press RETURN to cancel
the operation, or a \"u<RETURN>\" to un-do (erase) the current definition of
user action $FUNC when you are again asked for the menu name.





Press RETURN to continue ... "

                         read resp

                         $iDISBIN/Fclrscrn

                    else 
                         if [ `grep -c "^${MENU}-all" $iDIS/idis/control/deauth.qdef` = 0 ]
                         then if [ `grep -c "^$MENU;" $iDIS/idis/develop/select.dat` != 0 ]

                              then MENUOK=y
                                   SELECOK=n

                              else if [ "$MENU" = "xyzzy" ]
                                   then echo "
Your entry contained invalid characters.  Please try again."
                                   else echo "
The \"${MENU}\" menu could not be found.  Check your spelling and try again."
                                   fi

                              fi
                         else echo "
The \"${MENU}\" menu is NOT authorized for user action definitions!"

                         fi
                    fi

              fi

          done

# Now we need to get the selection from the defining menu, or a "RETURN" to
# cancel the operation, or a "?" to request help.

              $iDISBIN/Fclrscrn
              while [ "$SELECOK" = "n" -a "$FUNCOK" = "y" ]
              do
                 echo -n "
The menu defining user action $FUNC is \"$MENU\"

Make an entry as described below, then press RETURN:

  The selection on the \"${MENU}\" menu which defines user action $FUNC,
  A \"?<RETURN>\" for help, or 
  A \"<RETURN>\" by itself to cancel the operation

Your entry: "

                 read SELEC

# The following handles oddball characters

              case $SELEC in *[\ \!\@\#\$\%\^\&\*\(\)\_\-\+\=\}\{\|\[\]\'\"\;\:\/\.\>\,\<\`\~]*) SELEC=xyzzy
              ;;
              esac

                 if [ "$SELEC" = "" ]

                 then echo "
Operation canceled!
"
                      exit 1

                 fi

                 if [ "$SELEC" = "?" ]

                 then echo -n "
        THE SELECTION PORTION OF A USER ACTION DEFINITION

So far, your entries have selected user action $FUNC to be defined by the
\"${MENU}\" menu.

You are now being requested to enter the selection from the \"${MENU}\"
menu that you want to equate to user action $FUNC. 

Menu selections which lead to another menu will be disallowed as user
action definitions.  Some selections may also be disallowed if their
use as a user action definition would result in incorrect operation.

If you do not know the name of the selection you want to define user
action $FUNC, then you should enter a RETURN to cancel the operation
when you are again asked for the selection.







Press RETURN to continue ... "

                      read resp
                      $iDISBIN/Fclrscrn

                 else if [ `grep -c ${MENU}-${SELEC} \
                                $iDIS/idis/control/deauth.qdef` = 0 \
                         -a "$SELEC" != "xyzzy" ]

                      then if [ `grep -c "^${MENU};[ 	]*${SELEC};" \
                                     $iDIS/idis/develop/select.dat` != 0 ]

                           then echo -n "
Installing definition of user action $FUNC ..."

                                ORIGIFS=$IFS

                                IFS=\;

                                set `grep "${MENU};[ 	]*${SELEC};" $iDIS/idis/develop/select.dat`

                                shift;shift

                                NEXTMENU=`echo $1 | awk -F\	 '{print $2}'`

                                shift;shift

                                IFS=$ORIGIFS

                                if [ "$NEXTMENU" != "" ]

                                then echo "
The \"${SELEC}\" selection from the \"${MENU}\" menu cannot be used to
define user action $FUNC because it results in the \"${NEXTMENU}\" menu
being displayed.

Check the spelling of your entry.  If it is correct, you probably want
to define the user action on \"${NEXTMENU}\" menu. To define the user action
on \"${NEXTMENU}\" menu, you need to cancel the user action definition that
you are in the middle of defining by typing in a RETURN."

                                else SELECOK=y

                                     grep "${MENU};[ 	]*${SELEC};" \
                                       $iDIS/idis/develop/select.dat \
                                     | $iDISBIN/Uselect -s \; 4+     \
                                     | tr ';' '\012' > $USR/.${FUNC}.mac

                                     if [ "`cat $USR/.${FUNC}.mac`" = "" ]

                                     then echo $@ > $USR/.${FUNC}.mac

                                     fi

                                     set `grep "~${SELEC}[ 	]*" $iDIS/idis/develop/${MENU}.mnu`

                                     shift;shift

                                     SELECTEXT=`echo $@ | awk -F~ '{print $1}'`

                                     echo "User action $FUNC is the \"${SELEC}\" selection from the \"${MENU}\" menu.
              ==> $SELECTEXT" > $USR/.func$FUNC

                                fi

                           else echo "
The \"${SELEC}\" selection was not found on the \"${MENU}\" menu.  Check your
spelling and try again."

                           fi
                      else if [ "$SELEC" = "xyzzy" ]
                           then echo "
Your entry contained invalid characters.  Please try again."
                           else echo "
The \"${SELEC}\" selection on the \"${MENU}\" menu is NOT authorized for
user defined action definitions!"
                           fi

                      fi

                 fi
              done

            fi

      done

done

echo
