: SCRIPT Frecn.ss
# Copyright 1986 Intel Corporation
# File management - reconstruct a mailed file to original form
#
# Parms are:
#	$1 : cabinet_type (or 'EMAIL' if called from Email menu)
#	$n : files to be reconstructed
#
trap ' rm -rf .iTEMP$$ ; trap 0 ; exit ; ' 0 1 2 3 15
dc=$1; shift
if [ "$dc" = "EMAIL" ] ; then
	cd $USR
	umask 077
fi
echo "Press RETURN to bypass a file, or DEL to return to menu"
while [ $# -ne 0 ] ; do
	while true ; do
		echo
		echo  "Enter name for reconstructed copy of $1"
		echo -n "     (or '=' to reconstruct in-place) ==> "
		read newname
		if [ "$newname" = "" ] ; then
			echo "$1 was not modified"
			break
		fi
		if [ "$newname" = "=" ] ; then
			newname=$1
		elif $iDISBIN/Fbadname.ss $newname $dc ; then
			continue
		fi
		if [ -r $newname -a ! -w $newname ] ; then
			echo "Sorry, $newname cannot be modified ... choose again"
			continue
		fi
		if [ -r $newname -a $1 != $newname ] ; then
			echo -n "$newname already exists ... delete it? (y or n): "
			read a
			if [ "$a" = "y" ] ; then
				rm -rf $newname
			else
				continue
			fi
		fi
		rm -rf .iTEMP$$
		mv $1 .iTEMP$$
		if $iDISBIN/Frecv <.iTEMP$$ | $iDISBIN/Fatob $TMPDIR >$newname ; then
			if [ $1 = $newname ] ; then
				echo -n "File $newname reconstructed"
				echo
				rm -f .iTEMP$$
			else
				mv .iTEMP$$ $1
				echo -n "File $newname created"
				echo -n " ... remove $1? (y or n): "
				read yn
				if [ "$yn" = "y" ] ; then
					rm -f $1
				fi
			fi
		else
			rm -f $newname
			mv .iTEMP$$ $1
			echo "$1 was not successfully reconstructed"
		fi
		break
	done
	shift
done
