: 'Copyright 1986 Intel Corp.'
# Auseri.ss, build raw transaction for "Add User"
#
# 06/12/86 ugg  validate the home filesystem
# 07/11/86 oer  add provision for conversion of 1.6 users to 2.0
# 07/31/86 dan added logic to generate /etc/drm/finder.rsrc entry if a
#              template is provided.  this was needed to automatically
#              generate the keyoperator finder.rsrc entry at the same
#              time a keyoperator finder.assign entry is created.
# 08/04/86 oer if finder.rsrc or finder.assign exist in a template, cause the
#	       drm files to get immediately propagated.

Ausr=$1		shift
Apw=$1		shift
HomeNode=$1	shift
HomeFS=$1	shift
Template=$1
FirstN="$2"
MiddleN="$3"
LastN="$4"
Ophone="$5"
Oloc="$6"
Oinfo="$7"
Oinfo2="$8"
Auid=$9

#  First make sure the $HomeFS filesystem is valid.

if [ "$OPENNET" = "y" ] ; then
   node=$HomeNode
   reference="the node $node"
   pattern=":file-system:$node:"
   command="$iDISBIN/Uselect -s : 3 2 $node"
   sedpat="$pattern"
   field=2
else
   node=
   reference="this system"
   pattern=":file-system:"
   command="$iDISBIN/Uselect -s : 3"
   sedpat="$pattern\([^:]*\):"
   field=3
fi

if [ `egrep ":file-system:" $MASNODEP/etc/drm/finder.rsrc | $command | egrep -c "/dev/$HomeFS$" ` = 0 ] ; then
   
     echo " 
The $HomeFS filesystem on $reference is not specified as a resource.
If the $HomeFS filesystem is present on $reference, you need to specify 
it as a 'file-system' type resource before you can define the user's home 
on $HomeFS filesystem.
	"

     if egrep "$pattern" $MASNODEP/etc/drm/finder.rsrc >/dev/null ; then 
        echo "
The following filesystem(s) are currently defined on $reference:
	"

        sed -n -e 's/^\([^:]*\)'$sedpat'\/dev\/\([^:]*\):.*$/'\\$field'/p' $MASNODEP/etc/drm/finder.rsrc | sort | pr -5 -w79 -t
     else
        echo "
No filesystems for $reference are specified in the iDIS resource 
specifications.
	"
     fi

     exit 1
fi
#
case $OPENNET in
	n) Home=/$HomeFS/$Ausr ;;
	*) Home=//$HomeNode/$HomeFS/$Ausr ;;
esac

ORIGIFS=$IFS
IFS=:
set `cat $MASNODEP/etc/Templates/$Template/passwd`
IFS=$ORIGIFS
Gid=$4
Lshell=$7

# if there was a passwd requested, capture it and encrypt it
case $Apw in
	no) Aepw=none ;;
	*)  echo "(DEL, at this point, will cancel this user initialization)"
	    Aepw=`$iDISBIN/Apwgen \`$iDISBIN/Agetpasswd\`` ;;
esac

# ignore interrupts from now on (don't let hangup or DEL kill it)
trap "" 1 2

Startuid=`cat $MASNODEP/etc/drm/baseUID`

# indicate is not an old (already existing user)
Olduser=no

# ensure that this user is unique
/iDISboot/Ar $iDISBIN/Aaddpwe $MASNODEP/etc/passwd $Startuid $Ausr \"$Aepw\" $Auid $Gid \"$LastN\;  $FirstN\" $Home $Lshell > /tmp/Aadd$$
rtn=$?
Auid=`cat /tmp/Aadd$$`; rm -f /tmp/Aadd$$
case $rtn in
	0) ;;
	1) echo "There is another user with the $Ausr Login ID."
	   echo "His master password entry follows:\n"
	   egrep \^$Ausr $MASNODEP/etc/passwd
	   echo "\nYou must choose a Login ID that is unique."
	   echo "This initialization has been rejected"
	   exit 1 ;;
	2) echo "There is another user with the $Auid User ID number."
	   echo "His master password entry follows:\n"
	   $iDISBIN/Uselect -s \: 0+ 2 $Auid < $MASNODEP/etc/passwd
	   echo "\nYou must choose a User ID that is unique, or let"
	   echo "one be automatically generated for you."
	   echo "This initialization has been rejected"
	   exit 1 ;;
	3) echo The master password file on node $MASNODE could not be accessed.
	   echo You must try again later when connection is established
	   exit 1 ;;
	4) echo "The Login ID you supplied ($Ausr) has an invalid format."
	   echo "The Login ID must be at least 3 characters, beginning with a letter."
	   echo "This initialization has been rejected"
	   exit 1 ;;
	5) echo "The User ID number you supplied, $Auid, is not legal."
	   # ACTUALLY 65535 IS ALSO LEGAL, FOR RMX OPENNET
	   echo "The number must be within 0 to 32767."
	   echo "This initialization has been rejected"
	   exit 1 ;;
	6) echo "There are no more User ID numbers available on this system."
	   echo "Please call your Intel support personnel for instructions."
	   echo "This initialization has been rejected"
	   exit 1 ;;
	7) Olduser=yes ;;
esac

# add to personnel directory (" is group separator)
cat <<HERE >> $MASNODEP/etc/Personnel
$Ausr		$FirstN $MiddleN $LastN"
		$Ophone  $Oloc
		$Oinfo  $Oinfo2
HERE

# if any resource assignments exist for this type template, add them
if [ -s $MASNODEP/etc/Templates/$Template/finder.assign ] ; then
   sed -e 's/loginID/'$Ausr'/g' \
      $MASNODEP/etc/Templates/$Template/finder.assign \
	 >> $MASNODEP/etc/drm/finder.assign
   RAW=/usr/tmp/$LOGINID.idisR
   case $OPENNET in
      y) cat <<-HERE >>$RAW
	#( update resource specifications over the network
	#) update resource specifications over the network
	HERE
      ;;
   esac
fi

# if any resources exist for this type template, add them
if [ -s $MASNODEP/etc/Templates/$Template/finder.rsrc ] ; then
   sed -e 's/loginID/'$Ausr'/g' -e 's/homenode/'$HomeNode'/g' \
      $MASNODEP/etc/Templates/$Template/finder.rsrc \
	 >> $MASNODEP/etc/drm/finder.rsrc
   RAW=/usr/tmp/$LOGINID.idisR
   case $OPENNET in
      y) cat <<-HERE >>$RAW
	#( update resource specifications over the network
	#) update resource specifications over the network
	HERE
      ;;
   esac
fi

# build the raw transaction file, signal pending
>   /usr/tmp/$LOGINID.idisP
RAW=/usr/tmp/$LOGINID.idisU
cat <<-HERE >> $RAW
	#( Add user $Ausr,   Template is $Template
	Kind=user
	Ttype=Init
	OPENNET="$OPENNET"
	MASNODE="$MASNODE"
	MASNODEP="$MASNODEP"
	Ausr="$Ausr"
	Aepw="$Aepw"
	HomeNode="$HomeNode"
	HomeFS="$HomeFS"
	Template="$Template"
	FirstN="$FirstN"
	MiddleN="$MiddleN"
	LastN="$LastN"
	Ophone="$Ophone"
	Oloc="$Oloc"
	Oinfo="$Oinfo"
	Oinfo2="$Oinfo2"
	Auid="$Auid"
	Gid="$Gid"
	Home="$Home"
	Lshell="$Lshell"
	Olduser="$Olduser"
	export Kind Ttype OPENNET MASNODE MASNODEP Ausr Aepw HomeNode HomeFS Template
	export FirstN MiddleN LastN Ophone Oloc Oinfo Oinfo2 Auid Gid Home Lshell Olduser
	#) Add user $Ausr,   Template is $Template
HERE

exit 0
