:
# "Asnranges.ss", A shell script to return the last used UID or GID value
#                 as derived from $MASNODEP/etc/drm/subnet.

# Copyright 1986 Intel Corporation.

# 05/20/86  gll  Written for iDIS R2.0.

# One script handles both uid and gid.

case $1 in uid) field=3
                ;;
           gid) field=5
                ;;
             *) field=3
                ;;
esac

maxsofar=0
for value in `$iDISBIN/Uselect -s : $field < /etc/drm/subnet` last
do
   # if there are no more values, then show the largest one and quit
   if [ "$value" = "last" ]
   then if [ $maxsofar -eq 0 -o $maxsofar -gt 32767 ]
        then echo "none"
             exit 1
        else echo $maxsofar
             exit 0
        fi
   fi

   # if this value is larger than all previous, keep it, else throw it away
   if [ $value -gt $maxsofar ]
   then maxsofar=$value
   fi

done
