:
# "Armsndups.ss", a shell script to remove duplicates from the master
#                 node and the new subnet master node that may result
#                 while adding the new subnet master.

# Copyright 1986 Intel Corporation.

# 07/05/86  gll  Written for iDIS R2.0.  Solves a memory fault problem
#                that occurred with Aaddsn.ss.

# Bring in the parameters:
#
#      1  --  Sub-Network Master Node Name

node=$1

# Now make sure no duplicates in /net/data, /net/cdf, and
# the finder.rsrc, finder.assign files on both the new
# node and the logical network master.

# Logical network master first

cat $MASNODEP/net/data | sort -u > $MASNODEP/net/data.tmp
chmod 644 $MASNODEP/net/data.tmp
chgrp root $MASNODEP/net/data.tmp
chown root $MASNODEP/net/data.tmp
mv $MASNODEP/net/data.tmp $MASNODEP/net/data

cat $MASNODEP/net/cdf | sort -u > $MASNODEP/net/cdf.tmp
chmod 644 $MASNODEP/net/cdf.tmp
chgrp root $MASNODEP/net/cdf.tmp
chown root $MASNODEP/net/cdf.tmp
mv $MASNODEP/net/cdf.tmp $MASNODEP/net/cdf

cat $MASNODEP/etc/drm/finder.rsrc | sort -u > $MASNODEP/etc/drm/rsrc.tmp
chmod 664 $MASNODEP/etc/drm/rsrc.tmp
chgrp 800 $MASNODEP/etc/drm/rsrc.tmp
chown 800 $MASNODEP/etc/drm/rsrc.tmp
mv $MASNODEP/etc/drm/rsrc.tmp $MASNODEP/etc/drm/finder.rsrc

cat $MASNODEP/etc/drm/finder.assign | sort -u > $MASNODEP/etc/drm/assign.tmp
chmod 664 $MASNODEP/etc/drm/assign.tmp
chgrp 800 $MASNODEP/etc/drm/assign.tmp
chown 800 $MASNODEP/etc/drm/assign.tmp
mv $MASNODEP/etc/drm/assign.tmp $MASNODEP/etc/drm/finder.assign

# New Sub-Network master last

cat //$node/net/data | sort -u > //$node/net/data.tmp
chmod 644 //$node/net/data.tmp
chgrp root //$node/net/data.tmp
chown root //$node/net/data.tmp
mv //$node/net/data.tmp //$node/net/data

cat //$node/net/cdf | sort -u > //$node/net/cdf.tmp
chmod 644 //$node/net/cdf.tmp
chgrp root //$node/net/cdf.tmp
chown root //$node/net/cdf.tmp
mv //$node/net/cdf.tmp //$node/net/cdf

cat //$node/etc/drm/finder.rsrc | sort -u > //$node/etc/drm/rsrc.tmp
chmod 664 //$node/etc/drm/rsrc.tmp
chgrp 800 //$node/etc/drm/rsrc.tmp
chown 800 //$node/etc/drm/rsrc.tmp
mv //$node/etc/drm/rsrc.tmp //$node/etc/drm/finder.rsrc

cat //$node/etc/drm/finder.assign | sort -u > //$node/etc/drm/assign.tmp
chmod 664 //$node/etc/drm/assign.tmp
chgrp 800 //$node/etc/drm/assign.tmp
chown 800 //$node/etc/drm/assign.tmp
mv //$node/etc/drm/assign.tmp //$node/etc/drm/finder.assign

# End of Armsndups.ss
