# "Anetv.ss", a shell script to display node information on the screen.

# Copyright 1986 Intel Corporation.

# 03/21/86  gll  Initial entry for iDIS R2.0.
# 05/13/86  rhc  add PATH for Ar usage
# 07/16/86  gll  improve ability to find Ethernet address.

PATH=/bin:/usr/bin	export PATH

# We do this until the user says to cancel, or we run out of nodes.

# First, prime the loop.  If there is not at least one name (the invoking
# menu macro should insure this), we abort with an error message.

maxlines=19
maxcols=7
colwid=10
continue=yes
nodename=${1-absent}
nodelist=$*

if [ "$nodename" = "absent" ]
then echo "
Anetv.ss: no node names specified!"
     exit 1
fi

# Enter the loop and process the first node name.

while [ "$continue" != "c" ]
do

# Clear the screen and indicate a slight pause.

$iDISBIN/Fclrscrn
echo "One moment please ..."

pentry=`grep -c ${nodename}/nfc $MASNODEP/net/data`

type=`$iDISBIN/Uselect -s : 1 0 ${nodename}/nfc < $MASNODEP/net/data`

vt=`grep -c ${nodename}/vts $MASNODEP/net/data`
if [ "$vt" = "0" ]
then vtstr="No virtual terminal capabilities"
else vtstr="Virtual terminal capabilities installed"
fi

# Get the Ethernet address for this node.  If no nfc entry for name,
# then try nfs.

if [ "$pentry" = "0" ]
then eaddr=`/iDISboot/Ar $iDISBIN/getnetaddr $nodename nfs`
else eaddr=`/iDISboot/Ar $iDISBIN/getnetaddr $nodename`
fi

# Now display the information nicely for the administrator.

$iDISBIN/Fclrscrn

echo "




========================================================================

Node name: $nodename  $also

Ethernet Address: $eaddr

Node Description: $type  $vtstr

========================================================================









"

# Now move to the next node, or quit if there are no more.

set $nodelist
shift
nodename=${1-absent}
nodelist=$*

if [ "$nodename" != "absent" ]
then echo "
Press RETURN to display information for the \"$nodename\" node,
        (\"c\" to cancel the remaining displays)"

     read continue
else continue=c
fi

done
echo
