# "Anetp.ss", a shell script to print nodeet/public server information.

# Copyright 1986 Intel Corporation.

# 03/22/86  gll  Initial entry for iDIS R2.0.
# 04/15/86  ugg  Modified to pass full pathname to lpr
# 05/13/86  rhc  add PATH for Ar usage
# 07/16/86  gll  improved ability to find ethernet address.
# 08/05/86  gll  add trap to prevent hangup on user logout.

trap "" 1 2 3 15

PATH=/bin:/usr/bin	export PATH

# We do this until we run out of nodes.

# First, prime the loop.  If there is not at least one name (the invoking
# menu macro should insure this), we abort with an error message.

maxlines=62
line=6
pgno=1
ldate="`date`"
continue=yes
nodename=${1-absent}
nodelist=$*
prnnode=`$iDISBIN/Uselect -es : 2 0 $CURPRTR < /etc/drm/finder.rsrc`

if [ "$prnnode" = "" ]
then OPENNET=n
fi

pid=$$

# Set trap to remove temp file in the event we're aborted

trap "rm -f /usr/tmp/Anetp.$pid; exit" 2 3 15

# Start the output file with a page header.

echo "$ldate   Sub-Network Node Information    Page $pgno\n\n" \
>> /usr/tmp/Anetp.$pid

# Now make sure there is at least one node to display.

if [ "$nodename" = "absent" ]
then echo "
Anetp.ss: no node names specified!" >> /usr/tmp/Anetp.$pid
     if [ "$OPENNET" = "y" ]
     then lpr -r -C $LOGINID -J nodes `net name`/usr/tmp/Anetp.$pid
     else lpr -r -C $LOGINID -J nodes /usr/tmp/Anetp.$pid
     fi
     exit 1
fi

# Enter the loop and process the first group name.

while [ "$continue" != "c" ]
do

# Establish type of node

pentry=`grep -c ${nodename}/nfc $MASNODEP/net/data`

type=`$iDISBIN/Uselect -s : 1 0 ${nodename}/nfc < $MASNODEP/net/data`

vt=`grep -c ${nodename}/vts $MASNODEP/net/data`
if [ "$vt" = "0" ]
then vtstr="No virtual terminal capabilities"
else vtstr="Virtual terminal capabilities installed"
fi

# Get the Ethernet address for this node.

if [ "$pentry" = "0" ]
then eaddr=`/iDISboot/Ar $iDISBIN/getnetaddr $nodename nfs`
else eaddr=`/iDISboot/Ar $iDISBIN/getnetaddr $nodename`
fi

# Now display the information nicely for the administrator.

echo "========================================================================

Node name: $nodename

Ethernet Address: $eaddr

Node Description: $type  $vtstr

" >> /usr/tmp/Anetp.$pid

line=`expr $line + 8`

if [ $line -gt $maxlines ]
then pgno=`expr $pgno + 1`
     line=6
echo "\n\n\n\n\n\n$ldate   Sub-Network Node Information    Page $pgno\n\n" \
>> /usr/tmp/Anetp.$pid
fi

# Now move to the next node, or quit if there are no more.

set $nodelist
shift
nodename=${1-absent}
nodelist=$*

if [ "$nodename" = "absent" ]
then continue=c
else

linesleft=`expr $maxlines - $line`

if [ $linesleft -le 8 ]
then 
     case $linesleft in 1) echo "\n\n\n">> /usr/tmp/Anetp.$pid;;
                        2) echo "\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                        3) echo "\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                        4) echo "\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                        5) echo "\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                        6) echo "\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                        7) echo "\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                        8) echo "\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                        9) echo "\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                       10) echo "\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                       11) echo "\n\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                       12) echo "\n\n\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
                       13) echo "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" >> /usr/tmp/Anetp.$pid;;
     esac
     pgno=`expr $pgno + 1`
     line=6
     echo "\n\n\n\n$ldate   Sub-Network Node Information    Page $pgno\n\n" \
     >> /usr/tmp/Anetp.$pid
else echo "\n" >> /usr/tmp/Anetp.$pid
     line=`$iDISBIN/Uinc $line 2`
fi

fi

done

# Finally, spool the file to the assigned printer

if [ "$OPENNET" = "y" ] ; then
   lpr -r -C $LOGINID -J nodes `net name`/usr/tmp/Anetp.$pid
else
   lpr -r -C $LOGINID -J nodes /usr/tmp/Anetp.$pid
fi
