               job  Multiple Tape Utility Program 1401-UT-039
               ctl  6311
     *
     * Card-to-tape, Tape-to-print, and Tape-to-card operations,
     * One at a time or all at once.
     *
     * Sense switches:
     *  B for BCD card-to-tape
     *  C for tape-to-print
     *  D for BCD tape-to-card
     *  E Interrupt operations for new sense-switch settings
     *    or new control card
     *  F for column-binary tape-to-card
     *  G for column-binary card-to-tape
     *  B&G for mixed column-binary and BCD card-to-tape.
     *
     * Card-to-tape is always to unit 1
     * Tape-to-print is always unit 2.  Records can be of variable
     *   length with variable blocking.  Lines are separated by record
     *   marks.
     * Tape-to-card is always unit 3.  Records are unblocked, 80
     *   characters for BCD and 160 characters for column binary.
     *
     * Control card
     *
     * Column 1: Punch a one (1) in column 1 when column 2 is punched
     *   or the print storage feature is not installed.  If column 2
     *   is not punched and print storage feature is installed, leave
     *   column 1 blank.
     *
     * Column 2: Tape-to-print forms control
     *   Blank - single space
     *   2     - Double space
     *   3     - Triple space
     *   4     - Program governs forms control -- space-suppress
     *           character causes single spacing
     *   5     - Program governs forms control -- space-suppress
     *           character causes record bypass
     *   For 4 or 5, the first character of each record determines
     *   line spacing.
     *     Character       Operation
     *       &             Suppress spacing
     *       Blank         Single space
     *       0             Double space
     *       - (11 punch)  Triple space
     *       1-9 or J-R    Skip to channels 1-9 before printing
     *
     * Column 3: Not used (no 705 group mark 12-5-8 support)
     *
     * Column 4: Not used
     *
     * Columns 5-6: Number of files to skip on unit 1 before beginning
     *   card-to-tape operation.
     * Columns 7-8: Number of files to skip on unit 2 before beginning
     *   tape-to-print operation.
     * Columns 9-10: Number of files to skip on unit 3 before beginning
     *   tape-to-card operation.
     *
     * Assumes advanced-programming and index registers.
     *
     * Doesn't bother with read release, or punch release, since it
     * will probably only ever be used in a simulator.
     *
     * Halts indicated by A- and B-address register contents:
     *  000: All done.  Press start to read a new control card.
     *  111: Sense switch E requests interruption.  Change sense switch
     *       settings if desired.  Leave sense switch E on and press
     *       start to read a new control card.  Otherwise, just press
     *       start
     *  222: More than ten read errors on unit 2.  Press start to
     *       accept the block.
     *  333: A new control card has been read.  Turn off sense switch
     *       E and press start.
     *  666: More than 49 skips on unit 1.  Tape is unusable.  Mount
     *       new tape and press start.
     *  999: Output tape on unit 1 is full.  Rewind tape, mount new
     *       tape, tape, and press start.
     *
               org  87
     xxxxx1    dcw  #3
               dc   #2
     xxxxx2    dcw  #3
               dc   #2
     xxxxx3    dcw  #3
     *
     * Initialization
     *
               org  336
     start     b    sswich      Store sense switch settings
               b    ctlcd
               b    init        Initialize some switches
               job  Activity loop
     *
     loop      cw   loopsw      Do not repeat if no work
               nop
     bcd2ts    b    bcd2tp      BCD-to-tape -- SS B
               nop
     tp2prs    b    tape2p      Tape-to-print -- SS C
               nop
     t2bcds    b    tp2bcd      Tape-to-BCD -- SS D
               nop
     t2cbsw    b    t2cbin      Tape-to-column-binary -- SS F
               nop
     cb2tsw    b    cbin2t      Column-binary-to-tape -- SS G
               nop
     mixsbg    b    mixed       Both SS B and SS G
               bss  intrpt,E
               nop
     loopsw    b    loop
               nop  000
               h
               b    start
               dcw  #1
               job  Analyze sense switch settings
     *
     * B means BCD-to-tape on unit 1
     * B and G means mixed BCD-to-tape and column-binary-to-tape
     * C means tape-to-print from unit 2
     * D means tape-to-BCD from unit 3
     * D on doesn't test F
     * E means read a new control card (not tested here)
     * F means tape-to-column-binary from unit 3
     * G means column-binary-to-tape on unit 1
     *
               org  581
     sswich    sbr  sswicx+3
               sw   bcd2ts,tp2prs  Turn on
               sw   t2bcds,t2cbsw    all activity
               sw   cb2tsw,loopsw      loop switches
               cw   mixsbg         except mixed BCD and column binary
               bss  ssb,b       Q. BCD-to-tape requested
               cw   bcd2ts      Turn off BCD-to-tape
               bss  *&5,g       Q. Column-binary-to-tape requested
               cw   cb2tsw      Turn off column-binary-to-tape
     ssc       bss  *&5,c       Q. Tape-to-print requested
               cw   tp2prs      Turn off tape-to-print
               bss  ssd,d       Q. Tape-to-BCD requested
               cw   t2bcds      Turn off tape-to-BCD
               b    *&5
     ssd       cw   t2cbsw      Turn off tape-to-column-binary
               bss  *&5,f       Q. tape-to-column-binary requested
               cw   t2cbsw      Turn off tape-to-column-binary
     sswicx    b    0-0
     ssb       bss  ssbg,g      Q. Both B and G
               cw   cb2tsw      Turn off column-binary-to-tape
               b    ssc         Test for other requests
     ssbg      sw   mixsbg
               b    ssc         Test for other requests
               job  Process control card
     *
     ctlcd     sbr  ctlcdx+3
               r
               b    skfile
               dcw  06          files to skip before card-to-tape
               dcw  1           card-to-tape unit
               b    skfile
               dcw  08          files to skip before tape-to-print
               dcw  2           tape-to-print unit
               b    skfile
               dcw  10          files to skip before tape-to-card
               dcw  3           tape-to-card unit
               mcw  2,formsw#1  forms control
               mcw  1,pstorg#1  1 = no print storage, or forms control
     ctlcdx    b    0-0
               job  Skip files
     *    b    skfile
     *    dcw  nn        Address in read area of count
     *    dcw  u         Unit number
     *
     skfile    sbr  xxxxx3
               mcw  1+x3,xxxxx2  Count address in read area
               mcw  0+x2,count#2
               mn   2+x3,skrd+3  Unit number
               mn   2+x3,skend
               mn   2+x3,skbsp 
     sklp      s    +1,count
               bwz  3+x3,count,k
     skrd      cu   %u0,a       Diagnostic read
               bef  skend
               b    skrd
     skend     cu   %u0,a       Diagnostic read again to test for 2 EOFs
     skbsp     bsp  0
               bef  3+x3
               b    sklp
               job  Interrupt processing routine, on SS E
     *
     * Read new sense switch settings.  If SS E is still on,
     * read a new control card.
     *
     intrpt    sw   loopsw      Repeat activity loop
               b    init        Initialize some switches
     intrph    nop  111
               h
               b    sswich      Get new sense switch settings
               bss  *+5,e
               b    loopsw
               b    ctlcd
               nop  333
               h
               bss  intrph,e
               b    loopsw
               job  Initialize some switches
     *
     init      sbr  initx+3
               sw   needcd#1    Need a card
               lca  gmwmxx,81
     initx     b    0-0
               job  card-to-tape
     *
     * BCD card-to-tape
     *
               sfx  b
     bcd2tp    sbr  exit+3
               ss   $           Turn on overlap
               bw   rd,needcd   Need a card, not waiting for one
               bin  out,h       Reader busy
               sbr  skpct,950   9 retries, 50 skips
               bce  wtm,1,{     TM, 7-8
     wtape     lca  gmwmxx,81
               wt   1,1
               ber  tperrw      Check for error
               bef  full        Tape is full
     rd        blc  lst cd
               r                Read a card in overlap
               cw   needcd
     out       sw   loopsw      Repeat activity loop
     exit      b    0-0
     * Card had 7-8 in column 1.  Write EOF.
     wtm       wtm  1
               dcw  @N00@       Pad out to eight characters
               ber  tperrw      Check for error
               b    rd
     * Last card switch is on
     lst cd    wtm  1           Last card, write tape mark
               dcw  @N00@       Pad out to eight characters
               ber  tperrw      Check for error
               wtm  1           Write another tape mark
               dcw  @N00@       Pad out to eight characters
               ber  tperrw      Check for error
               bsp  1           Backspace over one tape mark
               cw   bcd2ts,cb2tsw  Turn off reading
               b    exit
     * Tape full.  Do not check for error, because this could result
     * in 50 skips, i.e., 175 inches, which might unspool the tape.
     full      wtm  1
               nop  999         Tape full
               h
               b    wtape
     *
     * Column binary card-to-tape
     *
     cbin2t    sbr  exit+3
               blc  lst cd
     rcb       rcb
               bce  wtmb,1,{    TM, 7-8
               sw   401
     wtapec    lca  gmwmxx,binbuf+160
               mbd  580,binbuf+159
               wtb  1,binbuf
               ber  tperrw
               bef  fullb
               b    out
     * Card had 7-8 in column 1.  Write EOF.
     wtmb      wtm  1
               dcw  @N00@       Pad out to eight characters
               ber  tperrw      Check for error
               b    rcb
     * Tape full.  Do not check for error, because this could result
     * in 50 skips, i.e., 175 inches, which might unspool the tape.
     fullb     wtm  1
               nop  999         Tape full
               h
               b    wtapec
     *
     * Tape output error handler, clobbers X3
     *
     tperrw    sbr  xxxxx3
               bsp  1
               s    +1,ercnt
               bwz  *+5,ercnt,k  Skip tape after nine errors
               b    15987+x3     Otherwise try again
               a    +1,skpct
               bav  skips       Error if more than 50 skips
               skp  1
               bef  full        Tape is full
               mcw  +9,ercnt    Reset error count
               b    15987+x3    and try again
     skips     nop  666         Too many skips
               h
               sbr  skpct,950   9 retries, 50 skips
               b    15987+x3    Try again
     * Tape is full.  Do not check for error here so as not to unspool
     * the tape.
     erfull    wtm  1
               nop  999
               h
               b    15987+x3    Try again
     ercnt     dcw  #1          Tape error count
     skpct     dcw  #2          Skip count
               job  Tape-to-print
     *
               sfx  p
     tape2p    sbr  t2px+3
               sw   loopsw      Repeat activity loop
               bce  prtpos,pstorg,  Skip busy tests if no print storage
               bin  t2px,p      Printer busy
               bpcb t2px        Printer carriage busy
     prtpos    sbr  xxxxx3,gmwmxx+1
               bce  read,15999+x3,}  GM 12-7-8
               sbr  xxxxx2,200
               bbe  use200,formsw,4  4 or 5
               sbr  xxxxx2,201
     use200    mcw  prtpos&6,xxxxx3
               mcm  0&x3,0&x2
               mcw  @  @        Clear record mark
               mcm  0&x3
               sar  prtpos+6    Update buffer address
               bbe  prctl,formsw,4  4 or 5
     print     w
               cs
               cs
               bce  *&5,formsw,2
               b    *&3
               cc   J           Immediate skip one space
               bce  *&5,formsw,3
               b    *&3
               cc   K           Immediate skip two spaces
               bcv  *&5         Q. Page full
               b    *&3         No
               cc   1           Yes, skip to channel 1
     t2px      b    0-0
     *
     * Program controls print spacing
     *
     prctl     bce  supprs,200,+
               bce  print,200,  Single space
               bce  *&5,200,0
               b    *&6
               ccb  print,J     Immediate skip one space
               bce  *&5,200,-
               b    *&6
               ccb  print,K     Immediate skip two spaces
               mn   200,*&5     Immediate skip to channel
               ccb  print,0
     *
     * & in column 1
     *
     supprs    bce  t2px,formsw,5  Skip the record
                  2s            Print without spacing
               cs
               cs
               b    t2px
     *
     * Read a block for printing
     *
     read      sbr  readx+3
               sbr  prtpos+6,prtbuf
               cw   15999+x3    Turn off GMWM from previous read
               sw   gmwmxx      The first call clears this
               b    readit
               rt   2,prtbuf
               bef  done
     readx     b    0-0
     *
     * End of file
     *
     done      cc   1
               b    readit
               rt   2,prtbuf
               bef  *&5
               b    readx
     * Two end-of-file marks in a row.  Turn off printing
               cw   tp2prs
               rwu  2
               b    t2px
               job  Tape-to-card
     *
     * Tape-to-BCD card
     *
               sfx  4
     tp2bcd    sbr  exit+3
               ss   $           Turn on overlap
               bin  exit,I      Punch busy
               lca  gmwmxx,81
               b    readit
               rt   3,101
               bef  done
               mcw  @ @,15999+x1  In case of short record
               p
     out       sw   loopsw      Repeat activity loop
     exit      ssb  0-0,2
     *
     * Tape-to-column-binary card
     *
     t2cbin    sbr  exit+3
               ss   .           Turn off overlap
               lca  gmwmxx,binbuf+181
               b    readit
               rtb  3,binbuf
               bef  donecb
               mcw  @ @,15999+x1  In case of short record
               sw   401
               mbc  binbuf+159,580
               pcb
               b    out
     *
     * End of file
     *
     done      sbr  xxxxx3
               b    readit
               rt   3,101
               b    test
     donecb    sbr  xxxxx3
               b    readit
               rtb  3,binbuf
     test      bef  final
               bce  two,exit+4,2
               mcw  @2@,exit+4  Change selected stacker
               b    0+x3
     two       mcw  @4@,exit+4  Change selected stacker
               b    0+x3
     final     cw   t2bcds,t2cbsw  Turn off punching
               rwu  3
               b    exit
               job  Tape read routine
     *
     * Clobbers all index registers
     * Leaves GMWM address +1 in X1
     *
               sfx  r
     readit    sbr  xxxxx3
               mcw  7+x3,rdtp+7
               za   errct#1
     rdtp      rt   0,0
               sbr  xxxxx1
               sw   15999+x1    Turn on GMWM from this read
               bef  8+x3
               mcw  rdtp+6,xxxxx2
               bce  rdtp,12+x2,}  GM
               chain12
               ber  tperrr
               b    8+x3
     tperrr    a    *-5,errct
               bce  halt,errct,I      Q. Is count +9
               mn   rdtp+4,*+4
               bsp  2
               b    rdtp
     halt      mn   rdtp+4,*+4
               nop  222
               h
               b    8+x3
               job  Work areas
               ltorg*
               sfx
               job  Mixed BCD and Binary card-to-tape
     *
     * Mixed BCD and Binary card-to-tape needs two buffers.  Each one
     * includes lookahead to tell what the next buffer is.  The lookaheads
     * are-
     *   9977 in 81-84 if previous is BCD and current is binary
     *   bbbb in 81-84 if previous is BCD and current is BCD
     *   b5b1b5b4 in 161-168 if previous is binary and current is BCD
     *   b4bbb1bb in 168-168 if previous is binary and current is binary.
     * The last record in the file is always marked as if the next record
     * is the same format.
     * The current card is considered to be column binary if and only if
     * it has both 7 and 9 punches in column 1.
     * Once we get started, current buffer address is in x2, and previous
     * buffer address is in x1
     *
     mixed     equ  *+1
               sfx  m
               sbr  mixedx+3
               ss   .              Turn off overlap
               mcw  curmix,xxxxx2  Current buffer
               mcw  othbuf+x2,xxxxx1  Previous buffer
     rcm       blc  wtmm           Q. Last card -- mixed
               rcb
               bce  wtmm,1,{       Q. Column 1 tape mark?
               sbr  curmix,0+x1    Swap buffers
               bbe  bin1,501,1     Q. Column 1 has 9 punch, Brownie P 90
     * Current card is BCD
     bcd       lca  gmwmxx,85+x2
               mcw  80,80+x2
               sw   bcd sw+x2      Mark current record as BCD
               nop
     mixeds    b    firstm         First-card switch
               bw   bcdbcd,bcd sw+x1    Q. Previous BCD
     * Current BCD, previous binary
               lca  gmwmxx,169+x1
               mcw  @ 5 1 5 4@     Previous binary, current BCD
     binout    wtb  1,0+x1
               ber  tperrw         Output error handler
     firstm    cw   mixeds         Turn off first-card switch
     out       sw   loopsw         Turn on loop
     mixedx    b    0-0
     * Current and previous both BCD
     bcdbcd    lca  gmwmxx,85+x1
               mcw  @    @         Previous binary, current BCD
     bcdout    wt   1,0+x1
               ber  tperrw         Output error handler
               cw   85+x1
               b    firstm
     * Passed first test for binary -- column 1 has 9 punch
     bin1      bbe  bin2,501,4     Q. Column 1 has 7 punch, Brownie P 90
               b    bcd            Column 1 not 7-9, so not binary
     * Current card is binary
     bin2      mbd  580,160+x2     Arrange for binary writing
               cw   bcd sw+x2
               bw   firstm,mixeds  Q. First card
               bw   binbcd,bcd sw+x1  Q. Previous BCD
     * Current and previous cards both binary
               lca  gmwmxx,169+x1
               mcw  @ 4   1  @
               b    binout
     * Current binary, previous BCD
     binbcd    lca  gmwmxx,85+x1
               mcw  @9977@
               b    bcdout
     * Card has 7-8 in column 1.  Write previous record, then EOF.
     wtmm      bw   wtmbcd,bcd sw+x1
               lca  gmwmxx,169+x1
               mcw  @ 4   1  @
               wtb  1,0+x1
               ber  tperrw         Output error handler
               bef  full
     wtmmix    wtm  1
               dcw  @N00@       Pad out to eight characters
               ber  tperrw      Check for error
               blc  mixend
               b    rcm
     wtmbcd    lca  gmwmxx,85+x1
               mcw  @    @
               wt   1,0+x1
               ber  tperrw
               bef  full
               b    wtmmix
     mixend    wtm  1
               dcw  @N00@       Pad out to eight characters
               ber  tperrw      Check for error
               sw   mixeds      Turn on first card switch
               cw   mixsbg      Turn off mixed input
               b    out
     * Tape is full.  Do not check for error because this might cause
     * fifty tape skips, thereby unspooling the tape
     full      sbr  fullx+3
               wtm  1
               nop  999
               h
     fullx     b    0-0
               ltorg*
               sfx
               job  Work areas
     curmix    dsa  binbuf      Current mixed-output buffer
     othbuf    equ  172         Offset from buf to other buf addr
     bcd sw    equ  173         Offset from buf to BCD switch   
     binbuf    da   1x168,g     Column binary tape buffer
               dsa  binbf2      Second buffer address
               dcw  #1          WM for BCD
     binbf2    da   1x168,g     Other column binary tape buffer
               dsa  binbuf      First buffer address
               dcw  #1          WM for BCD
     prtbuf    equ  *+1         Printer tape block buffer
               org  3999
     gmwmxx    dcw  @}@
               end  start
