#ifndef DIAGS__SHARK_H__LOADED
#define DIAGS__SHARK_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* (c) 1999 Alpha Processor, Inc, begun 8 September 2000 by Stig Telfer */
/* Details and definitions for the Shark (CS20) platform */


/* PCI device IDs */

#define PCI0_ALI_ISA	7	/* ALIM1543C ISA bus bridge */
#define PCI0_ALI_IDE	16	/* ALI M1543C IDE controller */
#define PCI0_ALI_PMU	17	/* ALI M1543C Power management unit */
#define PCI0_ALI_USB	20	/* ALI M1543C USB controller */

#define PCI0_INTC_ETH0	4	/* Intel Primary Ethernet controller */
#define PCI0_SYM_SCSI	3	/* Symbios 1010 SCSI controller */
#define PCI0_SLOT1	5	/* PCI slot 0 */
#define PCI1_SLOT2	4	/* PCI slot 1 */
#define PCI1_INTC_ETH1	3	/* Intel secondary Ethernet controller */


/* Global standard definitions */

#define PLAT_ISAID      PCI0_ALI_ISA
#define PLAT_IDEID      PCI0_ALI_IDE
#define PLAT_PMUID      PCI0_ALI_PMU
#define PLAT_USBID      PCI0_ALI_USB


/*----------------------------------------------------------------------*/
/* TIGbus IO magic numbers */
/* These routines can only be accessed by code that _knows_ it is in a
 * Tsunami system: ie, it can only be called from the platform and northbridge
 * modules */

/* the '>> 6' here is for conformity with writing the the flash ROM, for which
 * the addresses are shifted up by 6 */

/* EPLD Revisions (power EPLD and reset EPLD) */
#define TIG_EPLDREV	(0x28000000UL >> 6)     /* 3:0 power, 7:4 reset */


/* Motherboard config: */
/* Bit 0	Tsunami Speed 0	
 * Bit 1	Tsunami Speed 1	
 * Bit 2	Tsunami Speed 2	
 * Bit 3	CPU Speed 0	
 * Bit 4	CPU Speed 1	
 * Bit 5	CPU Speed 2	
 * Bit 6	Bcache Size 0	
 * Bit 7	Bcache Size 1	
 */
#define TIG_MBCFG       (0x30000000UL >> 6)     /* CPU & Mobo configuration */

/* Flash write enable (bit 0 = 1 to enable flash writes */
#define TIG_ROMENA	(0x30000040UL >> 6)     /* disable/enable writes*/

/* CPU Halt assert */
/* Bit 0	Write 1 to this bit will cause CPU 0 Halt	
 * Bit 1	Write 1 to this bit will cause CPU 1 Halt	
 */
#define TIG_CPUHALT	(0x300003C0UL >> 6)
#define TIG_CPUHALT2	(0x300005C0UL >> 6)	/* Duplicate */

/* CPU 0 Enable flag */
/* Bit 0	CPU 0 Enable Flag Register */
#define TIG_CPU0START	(0x30000A00UL >> 6)

/* CPU 1 Enable flag */
/* Bit 0	CPU 1 Enable Flag Register */
#define TIG_CPU1START	(0x30000A40UL >> 6)

/* Software jumper block settings */
/* Bit 0	SW Jumper 0
 * Bit 1	SW Jumper 1
 * Bit 2	SW Jumper 2
 * Bit 3	SW Jumper 3
 * Bit 4	SW Jumper 4
 * Bit 5	SW Jumper 5
 * Bit 6	CPU 1 Present(Low Active)
 * Bit 7	CPU 0 Present(Low Active)
 */
#define TIG_SWJBLK	(0x38000000UL >> 6)

/* PCI 0 SelfTest Flag */
/* Bit 0	PCI 0 SelfTest Flag Register */
#define TIG_PCI0TST	(0x38000040UL >> 6)

/* PCI 1 SelfTest Flag */
/* Bit 0	PCI 1 SelfTest Flag Register */
#define TIG_PCI1TST	(0x38000080UL >> 6)

/* Software Reset Flag */
/* Bit 0	Reset Flag Register */
#define TIG_SWRST	(0x38000100UL >> 6)	/* write 0, then 1 to reset */

/* PCI Arbiter revision */
#define TIG_ARBREV	(0x38000140UL >> 6)     /* 7:5 major, 4:0 minor */

/* TIG PAL Revision */
#define TIG_PALREV	(0x38000180UL >> 6)     /* 7:5 major, 4:0 minor */

#define TIG_MISC0       (0x30000A00UL >> 6)     /* for CPU0 start from SROM */
#define TIG_MISC1       (0x30000A40UL >> 6)     /* for CPU1 start from SROM */


/*--------------------------------------------------------------------*/
/* CS20 interrupt line configurations */


/* I2C SMBus */

#define IRQ_ADM_CPU0	44		/* CPU 0 ADM9240 monitor */
#define IRQ_ADM_CPU0_M	(1UL<<IRQ_ADM_CPU0)

#define IRQ_ADM_CPU1	45		/* CPU 1 ADM9240 monitor */
#define IRQ_ADM_CPU1_M	(1UL<<IRQ_ADM_CPU1)

#define IRQ_ADM_DCHP	46		/* D-Chip ADM9240 monitor */
#define IRQ_ADM_DCHP_M	(1UL<<IRQ_ADM_DCHP)

#define IRQ_ADM_PCI	47		/* PCI Riser ADM9240 monitor */
#define IRQ_ADM_PCI_M	(1UL<<IRQ_ADM_PCI)

#define IRQ_ADM_PSU	48		/* PSU ADM9240 monitor */
#define IRQ_ADM_PSU_M	(1UL<<IRQ_ADM_PSU)

#define IRQ_ADM_FANS	49		/* Front fans ADM9240 monitor */
#define IRQ_ADM_FANS_M	(1UL<<IRQ_ADM_FANS)


/* On-board Symbios SCSI controller */

#define IRQ_SCSIA	16		/* SMY53C1000 SCSI INTA */
#define IRQ_SCSIA_M	(1UL<<IRQ_SCSIA)

#define IRQ_SCSIB	17		/* SMY53C1000 SCSI INTB */
#define IRQ_SCSIB_M	(1UL<<IRQ_SCSIB)


/* ALI M1543C Southbridge interrupts */

#define IRQ_NMI		53		/* NMI raised by southbridge */
#define IRQ_NMI_M	(1UL<<IRQ_NMI)

#define IRQ_SMI		54		/* SMI raised by southbridge */
#define IRQ_SMI_M	(1UL<<IRQ_SMI)

#define	IRQ_INTR	55		/* ISA IRQ from southbridge */
#define IRQ_INTR_M	(1UL<<IRQ_INTR)


/* Pchip error interrupts */

#define IRQ_P0_ERROR	62		/* Error on PCI bus 0 */
#define IRQ_P0_ERROR_M	(1UL<<IRQ_P0_ERROR)

#define IRQ_P1_ERROR	61		/* Error on PCI bus 1 */
#define IRQ_P1_ERROR_M	(1UL<<IRQ_P1_ERROR)


/* On-board ethernet */

#define IRQ_ETH0	20		/* Primary i82559 */
#define	IRQ_ETH0_M	(1UL<<IRQ_ETH0)

#define IRQ_ETH1	32
#define IRQ_ETH1_M	(1UL<<IRQ_ETH1)


/* Slots on PCI bus 0 */

#define IRQ_P0_SLOT1	24		/* PCI bus 0 first slot INTA */
#define IRQ_P0_SLOT1_M	(1UL<<IRQ_P0_SLOT1)

#define IRQ_P0_SLOT2	28		/* PCI bus 0 second slot INTA */
#define IRQ_P0_SLOT2_M	(1UL<<IRQ_P0_SLOT2)

#define IRQ_P1_SLOT1	36		/* PCI bus 1 first slot INTA */
#define IRQ_P1_SLOT1_M	(1UL<<IRQ_P1_SLOT1)

#define IRQ_P1_SLOT2	40		/* PCI bus 1 second slot INTA */
#define IRQ_P1_SLOT2_M	(1UL<<IRQ_P1_SLOT2)


#define IRQ_ERR_NXM	(1UL<<63)	/* Triggers when "chip detects NXM" */


/*--------------------------------------------------------------------*/
/* CS20 CMOS/RTC configuration overrides */

/* Implementation note: Shark pass 1 uses a square wave generated by an EPLD
 * for the timer interrupt source.  The RTC has no part in timer interrupt 
 * generation.
 */

#define CM_STATUSB__INIT	( STATUSB_BIN | STATUSB_24HR) 


/*--------------------------------------------------------------------*/
/* I2C bus layout */


/* 
 * 1. CCHIP I2C Bus - EEPROMs on the DIMMs
 */

#define SHARK_I2C_DIMM0	0xA0
#define SHARK_I2C_DIMM1	0xA2
#define SHARK_I2C_DIMM2	0xA4
#define SHARK_I2C_DIMM3	0xA6
#define SHARK_I2C_DIMM4	0xA8
#define SHARK_I2C_DIMM5	0xAA
#define SHARK_I2C_DIMM6	0xAC
#define SHARK_I2C_DIMM7	0xAE


/* PSU ADM9240 system monitoring components 
 * 
 * Thermal	monitor PSU temp	
 * +5V		5V Standby (biased to be 15% higher)
 * +12V		Main 12V Output	(biased to be 1.5% higher)
 * +2.5V	NC	
 * +3.3V	NC	
 * VCCP1	NC	
 * VCCP2	NC	
 * FAN0		PSU FAN 1	
 * FAN1		PSU FAN 2	
 * CI		NC	
 * VID[4:0]	PSU Revision[4:0]	
 */
#define SHARK_I2C_SMD4	0x58		/* on the PSU */



/*
 * 2. Local I2C Bus (on the M1543C PMU)
 */

/* 256-byte Motherboard asset info EEPROM */
#define SHARK_I2C_EPROM	0xA2


/* PCA8550	4-bit multiplexed/1-bit latched 5-bit I2C EEPROM	
 *	MuxOut A	NVRAM Wake Up Active High	
 *	MuxOut B	Normal SROM Select Active Low	
 *	MuxOut C	System Fail LED Active Low	
 *	MuxOut D		
 *	N-MuxOut 		
 */
#define	SHARK_I2C_MUX	0x9C


/* ADM9240 0				Thermal	monitor Primary Heatsink Temp.	
 *
 *	+5V	Connected to Main 5V Software can disable this	
 *	+12V	Connected to Main 12V Software can disable this	
 *	+2.5V	Connected to Main 2.5V Software can disable this	
 *	+3.3V	Connected to Main 3.3V Software can disable this	
 *	VCCP1	Core VCC for primary processor -
 * 		2.0V on EV67, 1.65V on EV68
 *	VCCP2	System Interface Termination Power(Linear Regulator, 2.0V Nom.)	
 *	FAN0	Front FAN 1	
 *	FAN1	Front FAN 2	
 *	CI	Chassis Intrution Jumper	
 *	VID[4:0]	VID For Primary processor 	
 *	INTR#	ADM9240 0 INTR	
 */
#define SHARK_I2C_SMD0	0x58		/* Under the Primary CPU Heatsink */


/* ADM9240 1				Thermal	monitor Secondary Heatsink Temp
 *
 *	+5V	Connected to Main 5V Software can disable this	
 *	+12V	Connected to Main 12V Software can disable this	
 *	+2.5V	Connected to Main 2.5V Software can disable this	
 *	+3.3V	Connected to Main 3.3V Software can disable this	
 *	VCCP1	Core VCC for secondary processor -
 * 		2.0V on EV67, 1.65V on EV68
 *	VCCP2	-12V(Linear Regulator)	
 *	FAN0	Front FAN 3	
 *	FAN1	Front FAN 4	
 *	CI	NC	
 *	VID[4:0]	VID For Secondary processor 	
 *	INTR#	ADM9240 1 INTR
 */
#define SHARK_I2C_SMD1	0x5A		/* Under the Secondary CPU Heatsink */


/* ADM9240 2				Thermal	monitor DIMM area Temp.	
 *
 *	+5V	Connected to Main 5V Software can disable this	
 *	+12V	Connected to Main 12V Software can disable this	
 *	+2.5V	Connected to Main 2.5V Software can disable this	
 *	+3.3V	Connected to Main 3.3V Software can disable this	
 *	VCCP1	1.5V Power for VDDQ	
 *	VCCP2	5V Standby	
 *	FAN0	Front FAN 5	
 *	FAN1	PSU FAN 3	
 *	CI	NC	
 *	VID[4:0]	Mother Board Revision[4:0]	
 *	INTR#	ADM9240 2 INTR	
 */
#define SHARK_I2C_SMD2	0x5C


/* 	PCF8574AT 0			Motherboard control register
 *	Bit 0	PSU_AC_FAIL#				- READ ONLY	
 *	Bit 1	I2C_HALT# ( NMI# )			- READ/WRITE	
 *	Bit 2	I2C_RESET_REQUEST#			- READ/WRITE	
 *	Bit 3	I2C_PSU_OUTPUT_INH#			- READ/WRITE	
 *			"0" : Disable RACK PSU POWER OUTPUT
 *	Bit 4	SW_P0_CPU_VRM_DISABLE#
 *	Bit 5	SW_P1_CPU_VRM_DISABLE#
 *	Bit 6	SW_SERIAL_PORT_SEL# 			- READ/WRITE	
 *			"1" : Select CPU UART on COM Port
 *			"0" : Select ISA UART on COM Port
 *	Bit 7	NC	
 *	INTR#	PCF8574 0 INTR	
 */
#define SHARK_I2C_REG0	0x70
#define 	SH_R0_AC_FAIL	(1<<0)
#define 	SH_R0_HALT	(1<<1)
#define 	SH_R0_RESET	(1<<2)
#define		SH_R0_PSU	(1<<3)
#define		SH_R0_VRM0	(1<<4)
#define		SH_R0_VRM1	(1<<5)
#define 	SH_R0_SERIAL	(1<<6)
#define 		SH_R0_SROM	(1<<6)
#define 		SH_R0_COM	(0<<6)


/*	ADM9240 3			Thermal	monitor PCI Riser Card Temp	
 *
 *	+5V	Connected to PCI 5V Software can disable this	
 *	+12V	Connected to PCI 12V Software can disable this	
 *	+2.5V	NC	
 *	+3.3V	Connected to PCI 3.3V Software can disable this	
 *	VCCP1	NC	
 *	VCCP2	NC	
 *	FAN0	PCI FAN 0	
 *	FAN1	PCI FAN 1	
 *	CI	NC	
 *	VID[4:0]	PCI Riser Card Revision[4:0]	
 *	INTR#	PCI I2C INTR	
 */
#define SHARK_I2C_SMD3	0x5E	/* On the PCI Riser Card */


/* 	PCF8574AT 3			IO board revision register 
 *
 *	Bit 0	IO Board Revision[0]	
 *	Bit 1	IO Board Revision[1]	
 *	Bit 2	IO Board Revision[2]	
 *	Bit 3	IO Board Revision[3]	
 *	Bit 4	IO Board Revision[4]	
 *	Bit 5	IO Board Revision[5]	
 *	Bit 6	IO Board Revision[6]	
 *	Bit 7	IO Board Revision[7]	
 *	INTR#	NC	
 */
#define SHARK_I2C_REG1 0x76


/*--------------------------------------------------------------------*/
/* Magic fixup functions */

/* Program the I2C register multiplexing between serial and SROM ports, by
 * choosing one of SH_R0_SERIAL or SH_R0_SROM as argument */

enum shark_serial_opts { SHARK_SROM, SHARK_COM };

extern DBM_STATUS shark_serial_select( const int );

extern void set_yellow_light( const BOOLEAN on );

#endif		/* DIAGS__SHARK_H__LOADED */
