#ifndef __LPT_H_LOADED
#define __LPT_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

enum lptReg { LPT_DATA = 0, LPT_STAT = 1, LPT_CTRL = 2 };

enum lptStatus {
        LPST_INT        = 1<<2,         /* 0x04 */
        LPST_ERR        = 1<<3,         /* 0x08 */
        LPST_DEVSEL     = 1<<4,         /* 0x10 */
        LPST_PAPER      = 1<<5,         /* 0x20 */
        LPST_ACK        = 1<<6,         /* 0x40 */
        LPST_BUSY       = 1<<7          /* 0x80 */
};

enum lptControl {
        LPCR_STROBE     = 1,
        LPCR_FEED       = 1<<1,
        LPCR_INIT       = 1<<2,
        LPCR_SELECT     = 1<<3,
        LPCR_INTEN      = 1<<4,
        LPCR_XDIR       = 1<<5
};


/* Test if printer is ready */
#define LP_READY(status)        ((status) & LPST_BUSY)

/* Test if the printer has error conditions */
#define LP_NO_ERROR(status)                                     \
         (((status) & (LPST_PAPER | LPST_DEVSEL | LPST_ERR )) ==     \
         (LPST_DEVSEL | LPST_ERR))



/* lowest-level access routines, simple IO should not require these */
void lptwb( io_dev D, enum lptReg r, unsigned char val );
unsigned char lptrb( io_dev D, enum lptReg r );



DBM_STATUS initLpt( io_dev D );

/* putchar */
void putcLpt( io_dev D, int c );

#endif	/* __LPT_H_LOADED */
