/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* SMP diagnostic test */
/* Begun by Stig Telfer, Alpha Processor Inc, 29 July 1999 */

#include "lib.h"
#include "uilib.h"
#include "smp.h"
#include "memory.h"
#include "cmos_rtc.h"
#include "platform.h"
#include "diagnostics/diagnostics.h"


/*----------------------------------------------------------------------*/
/* Test functions */

/* We attempt to start any secondary CPUs.  The mechanism for this is 
 * platform-dependent, and is implemented in the northbridge.
 */

static DBM_STATUS smp_start( int argc, char *argv[] ) 
{
    unsigned secs, last, elapsed;
    unsigned all_cpus_present = (1 << MAX_CPUS) - 1;

    /* detect a repeat performance */
    if ( !smp_primary() )
    {
	mobo_logf( LOG_INFO "SMP: secondary CPU %d started\n", smp_phys_id() );
	return STATUS_SUCCESS;
    }

    /* this line brings the secondary processors into diags, with this 
     * parallel job waiting for them */
    diags_subsys_stat( SYS_SMP, DEV_PROBING );
    plat_smpstart( primary_impure->PAL_BASE );
    mobo_logf( LOG_INFO "SMP: signalled secondary CPU\n" );

#define TIMEOUT 10

    last=0, elapsed=0;
    while ( smp_all_cpus != all_cpus_present )
    {
	secs = cmosrb( CM_SECS );
	if ( secs != last ) {
	    last = secs;
	    elapsed++;
	    if ( elapsed >= TIMEOUT ) {
		mobo_logf( LOG_CRIT "SMP: No response from secondary CPU\n");
		mobo_alertf( "Missing Secondary Processors!",
			"Some CPUs did not call in (expected %d CPUs).\r"
			"Bit-mask of absent processors is 0x%X, counted %d",
			MAX_CPUS, smp_all_cpus ^ all_cpus_present,
			smp_online_count );
		diags_subsys_stat( SYS_SMP, DEV_FAILED );
		return STATUS_FAILURE;
	    } else {
	        mobo_logf( LOG_WARN "SMP: still waiting for second CPU\n");
	    }
	}
    }

    /* DEBUG: perform a quick mutex test */
    smp_acquire( &disp_lock );
    mobo_alertf("Secondary CPU found",
		"I have found %d cpus total, mask is 0x%x", 
		smp_ncpus(), smp_all_cpus );
    smp_release( &disp_lock );

    diags_subsys_stat( SYS_SMP, DEV_SETUP );
    return STATUS_SUCCESS;
}


/*----------------------------------------------------------------------*/
/* SMP command line entry point */

static Cmd_t smp_cmds[] =
{
    {"Probe all CPUs for SMP capability", "start", smp_start, SYS_NONE },
    {"SMP inter-processor interrupt test","ipi",   smp_ipitest,   SYS_NONE },
};
#define NSMPCMDS	( sizeof(smp_cmds) / sizeof(Cmd_t) )


#define MAX_CMDLEN 16


DBM_STATUS smp( int argc, char *argv[] )
{
    const Cmd_t *C;

    if ( argc != 2)
    {
	mobo_alertf( "Usage",
		     "smp <smp-command>" );
	return STATUS_FAILURE;
    }

    C = mobo_cmdlookup( argv[1], smp_cmds, NSMPCMDS );
    if ( C == NULL )			return STATUS_FAILURE;


    mobo_logf( LOG_INFO "about to start SMP command '%s'...\n", C->name );

    return smp_exec( C->action );
}


