
#include <fcntl.h>
#include <signal.h>
#include <asm/types.h>
#include <linux/i2c-new.h>
#include <linux/i2c-dev.h>

int file;

void sig_handler(int dum)
{
	int res;

	if ((res = i2c_smbus_write_byte(file, 0xec)) < 0) {
		printf("write error %x\n", res);
	}
	exit(1);
}


main(int ac, char **av) 
{
  int busnum = 0; 
  int addr = 0x39; /* 7bit I2C address */
  int res, tmp;
  char filename[20];
  char drvname[50];
  char v = 0x0; 

  signal(SIGINT, sig_handler);

again:
  sprintf(filename, "/dev/i2c%d", busnum);
  if ((file = open(filename, O_RDWR)) < 0) {
	goto errorout;
  }

  if (ioctl(file,I2C_GETDRVNAME,drvname) < 0) {
	goto errorout;
  }
  if (strncmp(drvname, "PCF8584 algorithm", 17) != 0) {
	if (busnum == 0) {
		close(file);
		busnum++;
		goto again;
	} else
		goto errorout;
  }

  if (ioctl(file,I2C_SLAVE,addr) < 0) {
	goto errorout;
  }

  if (ac == 2 && (strcmp(av[1], "on") == 0 || strcmp(av[1], "off") == 0)) {
	if ((res = i2c_smbus_read_byte(file)) < 0) {
		printf("read error %x\n", res);
		goto errorout;
	}
	if ( (res&0x7e) != 0x6c) {
		printf("Invalid state %x\n", res);
		goto errorout;
	}
	if (strcmp(av[1], "on") == 0)
		res = res & 0x7f;
	else if (strcmp(av[1], "off") == 0)
		res = res | 0x80;
	if ((res = i2c_smbus_write_byte(file, res)) < 0) {
		printf("write error %x\n", res);
		goto errorout;
	}
  }
  else {
	  while (1) {
		if ((res = i2c_smbus_read_byte(file)) < 0) {
			printf("read error %x\n", res);
			goto errorout;
		}
		if ( (res&0x7e) != 0x6c) {
			printf("Invalid state %x\n", res);
			goto errorout;
		}
		res = (res & 0x7f) | (~(res & 0x80))&0x80;
		sleep(1);
		if ((res = i2c_smbus_write_byte(file, res)) < 0) {
			printf("write error %x\n", res);
			goto errorout;
		}
	  }
  }

  exit(1);

errorout:
	printf("Error\ncheck if i2c drivers are loaded\nOr 8574 is not responding\n");
	close(file);

}

