#ifndef HWMON__HWMON_CFG_H__LOADED
#define HWMON__HWMON_CFG_H__LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/*
 * $Author: slee $
 * $Revision: 1.5 $
 * $Id: hwmon_cfg.h,v 1.5 2001/01/12 04:34:38 slee Exp $
 */

#include "listmgr.h"

#define CONFIG_FILE_NAME "/etc/hwmon.conf"

/* Open the configuration file (statically(?) defined above) and parse it */
int parse_cfg( void );


typedef unsigned char address_t;

/*------------------------------------------------------------------------*/
/* PARAMETERS - Attributes relating to sensors; the smallest pieces of data */

/* Everything that can be described about volt sensors */
enum volt_param_types { VOLT_NOM, VOLT_MIN, VOLT_MAX };

typedef float volt_data_t;

typedef struct
{
    char info;
    volt_data_t data;
} volt_param_t;


/* Everything that can be described about fan sensors */
enum fan_param_types { FAN_NOM, FAN_MIN };

typedef unsigned short fan_data_t;

typedef struct
{
    char info;
    fan_data_t data;
} fan_param_t;



/* Everything that can be described about temperature sensors */
enum temp_param_types { TEMP_MAX, TEMP_HYST };

typedef float temp_data_t;

typedef struct
{
    char info;
    temp_data_t data;
} temp_param_t;



/* Lists of sensor info */
typedef union {
    temp_param_t temp;
    fan_param_t fan;
    volt_param_t volt;
} param_t;




/*------------------------------------------------------------------------*/
/* SENSORS - a measured quantity. */

enum sensor_types { SENSOR_TEMP, SENSOR_FAN, SENSOR_VOLT };

typedef struct {
    char type;			/* an enum sensor_types value */
    address_t addr;		/* dev-specific location within the device */
    const char *desc;		/* a string description of the quantity */
    list_t *P;			/* Parameters for the measured device */
} sensor_t;



/*------------------------------------------------------------------------*/
/* DEVICES - a chip that may contain any number of sensors */

typedef struct { 
    const char *desc;		/* Friendly name for describing this device */
    const char *modname;	/* OS-format name (also name of first module) */
    address_t addr;		/* I2C bus address (bit 0 is read/write)*/
    list_t *M;			/* Device Driver module requirements */
    list_t *S;			/* Sensors configured on this device */
} device_t;


/*------------------------------------------------------------------------*/
/* BUSES - a network linking any number of devices */

typedef struct {
    const char *desc;		/* Friendly name for this bus */
    list_t *M;			/* Bus Driver module requirements */
    list_t *D;			/* Devices on this bus */
} bus_t;


/* If we parse successfully, we get everything setup and the bus info is here */
extern list_t *i2c_buses;
extern list_t *i2c_toplevel_modules;
extern char *i2c_shutdown_command;

/*------------------------------------------------------------------------*/
#endif	/* HWMON__HWMON_CFG_H__LOADED */
