#!/bin/sh
#
# sysactled     This shell script takes care of starting and stopping
#               the system activity led service.
#
# chkconfig: 345 85 15
# description: syscatled monitors of CPU usage and many parts of the system
#		It needs many i2c drivers depends on system type.
#

# Source function library.
. /etc/rc.d/init.d/functions

# See how we were called.
case "$1" in
  start)
	# Start daemons.
	action "Starting system activity LED service: " insmod sysactled
	RETVAL=$?
	echo
	;;
  stop)
	# Stop daemons.
	action "Shutting down system activity LED service: " rmmod sysactled
	RETVAL=$?
	echo
	;;
  status)
	;;
  restart)
	echo -n "Restarting system activity LED service: "
	$0 stop
	$0 start
	echo "done."
	;;
  *)
	echo "Usage: sysactled {start|stop|status|restart}"
	exit 1
esac

exit 0
