
#define __u8 unsigned char
#define __u16 unsigned short

#include <fcntl.h>
#include <linux/i2c-new.h>
#include <linux/i2c-dev.h>

main(int ac, char **av) 
{
  int file;
  int busnum = 0; 
  int addr = 0x4e; /* The I2C address */
  int res, tmp;
  char filename[20];
  char drvname[50];
  char v = 0x0; 

  if (ac!=2 || (atoi(av[1]) != 0 && atoi(av[1]) != 2)) {
	printf("Argument please 0|2\n");
	exit(1);
  }

  v = atoi(av[1]);

again:
  sprintf(filename, "/dev/i2c%d", busnum);
  if ((file = open(filename, O_RDWR)) < 0) {
	goto errorout;
  }

  if (ioctl(file,I2C_GETDRVNAME,drvname) < 0) {
	goto errorout;
  }
  if (strncmp(drvname, "SMB driver for ALi chipset", 20) != 0) {
	if (busnum == 0) {
		close(file);
		busnum++;
		goto again;
	} else
		goto errorout;
  }

  if (ioctl(file,I2C_SLAVE,addr) < 0) {
	goto errorout;
  }

  if ((res = i2c_smbus_read_byte(file)) < 0) {
	goto errorout;
  }

  res &= ~0xf2;
  res |= v;

  tmp = (res ^ (res>>1) ^ (res>>2) ^ (res>>3)) & 1;
 
  res |= tmp << 4;

  res = i2c_smbus_write_byte(file, res);
  if (res < 0) {
	printf("Write error %d\n", res);
  }

  exit(1);

errorout:
	printf("Error\ncheck if i2c drivers are loaded\nOr 8550 is not responding\n");
	close(file);

}

