#ifndef __TSUNAMI_H_LOADED
#define __TSUNAMI_H_LOADED
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the copyright notice and this permission notice appear in all copies
of software and supporting documentation, and that the name of Digital not
be used in advertising or publicity pertaining to distribution of the software
without specific, written prior permission. Digital grants this permission
provided that you prominently mark, as not part of the original, any
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees
with regard to this software, including all implied warranties of fitness for
a particular purpose and merchantability, and makes no representations
regarding the use of, or the results of the use of, the software and
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at
your own risk.

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


#include "memory.h"

/*----------------------------------------------------------------------*/
/* Tsunami system memory map */


#define _PCI0_MEMORY    0x80000UL       /* PCI Memory space on bus 0 */

#define _TIG_BUS        0x80100UL

#define _PCHIP0_CSR     0x80180UL
#define _CCHIP_CSR      0x801A0UL
#define _DCHIP_CSR      0x801B0UL

#define _PCI0_IACK      0x801F8UL       /* Interrupt acknowledge cycles */
#define _PCI0_IO        0x801FCUL       /* IO space */
#define _PCI0_CONFIG    0x801FEUL       /* Configuration space */


#define _PCI1_MEMORY    0x80200UL       /* PCI Memory space on bus 1 */

#define _PCHIP1_CSR     0x80380UL

#define _PCI1_IACK      0x803F8UL       /* Interrupt acknowledge cycles */
#define _PCI1_IO        0x803FCUL       /* IO space */
#define _PCI1_CONFIG    0x803FEUL       /* Configuration space */


/* full 64-bit addresses */
/* NOTE - IACK is a per-bus thing, needs fixing here */

#define PCI0_MEM   (( _PCI0_MEMORY << 24 ) | DBM_SUPER )
#define PCI0_IACK  (( _PCI0_IACK << 24 )   | DBM_SUPER )
#define PCI0_IO    (( _PCI0_IO << 24 )     | DBM_SUPER )
#define PCI0_CFG   (( _PCI0_CONFIG << 24 ) | DBM_SUPER )

#define PCI1_MEM   (( _PCI1_MEMORY << 24 ) | DBM_SUPER )
#define PCI1_IACK  (( _PCI1_IACK << 24 )   | DBM_SUPER )
#define PCI1_IO    (( _PCI1_IO << 24 )     | DBM_SUPER )
#define PCI1_CFG   (( _PCI1_CONFIG << 24 ) | DBM_SUPER )

#define TIG_IO     (( _TIG_BUS << 24 )     | DBM_SUPER )

#define CCHIP_CSR  (( _CCHIP_CSR << 24 ) | DBM_SUPER )
#define DCHIP_CSR  (( _DCHIP_CSR << 24 ) | DBM_SUPER )
#define PCHIP0_CSR (( _PCHIP0_CSR << 24) | DBM_SUPER )
#define PCHIP1_CSR (( _PCHIP1_CSR << 24) | DBM_SUPER )



/*----------------------------------------------------------------------*/
/* Tsunami CSR definitions */


#define SOFT_RESET_BASE 0x80138
#define SOFT_RESET_check 0x0040
#define SOFT_RESET_invoke  0x0100

#define SYNCHRONIZE_CPU 0x80130
#define SYNCHRONIZE_CPU0 0x0A00
#define SYNCHRONIZE_CPU1 0x0A40
#define SYNCHRONIZE_CPU0_TRANSFER_ADDRESS_PHYS  0x100
#define SYNCHRONIZE_CPU1_TRANSFER_ADDRESS_PHYS  0x108


typedef union { 
	uint64	r;
	unsigned char pad[64];
} tsunami_csr;

extern tsunami_csr *pchip0, *pchip1, *cchip;

enum cchip_csr {
	CSC,				/* 0x000: Chipset config register */
	MTR,				/* 0x040: Memory timing register */
	MISC,				/* 0x080: Misc register */
	MPD,				/* 0x0C0: Mem presence detect */
	AAR0, AAR1, AAR2, AAR3,		/* 0x100: Array address regs 0-3 */
	DIM0, DIM1,			/* 0x200: Device int masks 0-1 */
	DIR0, DIR1,			/* 0x280: Device int request 0-1 */
	DRIR,				/* 0x300: Dev raw int request */
	PRBEN,				/* 0x340: Probe enable */
	IIC0, IIC1,			/* 0x380: Interval ignore count */
	MPR0, MPR1, MPR2, MPR3,		/* 0x400: Memory programming */
	CC_RSRVD1, CC_RSRVD2,		/* 0x500: reserved */
	TTR,				/* 0x580: Tigbus timing */
	TDR				/* 0x5C0: Tigbus device timing */
};


enum pchip_csr {
	WSBA0, WSBA1, WSBA2, WSBA3,	/* 0x000: Window-space base addresses */
	WSM0, WSM1, WSM2, WSM3,		/* 0x100: Window-space masks */
	TBA0, TBA1, TBA2, TBA3,		/* 0x200: Translated base addresses */
	PCTL,				/* 0x300: Pchip control */
	PLAT,				/* 0x340: master latency register */
	PC_RSRVD1,			/* 0x380: reserved */
	PERROR,				/* 0x3C0: Pchip error register */
	PERRMASK,			/* 0x400: Error mask register */
	PERRSET,			/* 0x440: Error set register */
	TLBIV,				/* 0x480: TB invalidate virtual reg */
	TLBIA,				/* 0x4C0: TB invalidate all reg */
	PMONCTL,			/* 0x500: pchip monitor control */
	PMONCNT				/* 0x540: pchip monitor counters */
};

enum dcip_csr {
	DSC=0x20,			/* 0x800: */
	STR,				/* 0x840: */
	DREV,				/* 0x880: */
	DSC2				/* 0x8C0: */
};


/*                                                                          */
/* TSUNAMI Cchip MISC register.  See Tsunami ref ch 10.2.2.3                */
/*                                                                          */

#define misc_m_cpuid	0x0000000000000003UL
#define misc_m_itintr	0x00000000000000F0UL	/* interval timer int pending */
#define misc_m_ipintr	0x0000000000000F00UL	/* IPI pending */
#define misc_m_ipreq	0x000000000000F000UL	/* IPI request */
#define misc_s_ipreq	12			/* IPI request */
#define misc_m_abw	0x00000000000F0000UL	/* Arbitration won */
#define misc_m_abt	0x0000000000F00000UL	/* Arbitration try */
#define misc_m_acl	0x0000000001000000UL	/* Arbitration clear */

#define misc_m_nxm	0x0000000010000000UL	/* NXM error occurred */
#define misc_m_nxs	0x00000000E0000000UL	/* device causing NXM */
#define misc_s_nxs	29			/* shift value */
#define misc_nxs_cpu0	0
#define misc_nxs_cpu1	1
#define misc_nxs_pchip0	4
#define misc_nxs_pchip1	5

#define misc_m_rev	0x000000FF00000000UL	/* Cchip revision data */
#define misc_s_rev	32

#define misc_m_devsup	0x00000F0000000000UL	/* stop IRQ1 for poll cycle */



/*                                                                          */
/* TSUNAMI Pchip Error register.  See Tsunami ref ch 10.2.4.6               */
/*                                                                          */
#define perror_m_lost	0x0000000000000001UL	/* newer error data was lost */
#define perror_m_serr	0x0000000000000002UL
#define perror_m_perr	0x0000000000000004UL
#define perror_m_dcrto	0x0000000000000008UL
#define perror_m_sge	0x0000000000000010UL
#define perror_m_ape	0x0000000000000020UL
#define perror_m_ta	0x0000000000000040UL
#define perror_m_rdpe	0x0000000000000080UL
#define perror_m_nds	0x0000000000000100UL	/* no DEVSEL: not an error */
#define perror_m_rto	0x0000000000000200UL
#define perror_m_uecc	0x0000000000000400UL
#define perror_m_cre	0x0000000000000800UL
#define perror_m_ebits	0x0000000000000DFEUL	/* mask of error conditions */

#define perror_m_addrl	0x0000FFFFFFFF0000UL
#define perror_m_addrh	0x0007000000000000UL
#define perror_m_addr	0x0007FFFFFFFF0000UL
#define perror_s_addr	16

#define perror_m_inv	0x0008000000000000UL	/* if set, CSR is invalid */
#define perror_s_inv	51

#define perror_m_cmd	0x00F0000000000000UL
#define perror_s_cmd	52

#define perror_m_syn	0xFF00000000000000UL
#define perror_s_syn	56

union TPchipPERROR {
    struct  {
        unsigned int perror_v_lost : 1;
        unsigned perror_v_serr : 1;
        unsigned perror_v_perr : 1;
        unsigned perror_v_dcrto : 1;
        unsigned perror_v_sge : 1;
        unsigned perror_v_ape : 1;
        unsigned perror_v_ta : 1;
        unsigned perror_v_rdpe : 1;
        unsigned perror_v_nds : 1;
        unsigned perror_v_rto : 1;
        unsigned perror_v_uecc : 1;
        unsigned perror_v_cre : 1;
        unsigned perror_v_rsvd1 : 4;
        unsigned perror_v_addrl : 32;
        unsigned perror_v_addrh : 3;
        unsigned perror_v_rsvd2 : 1;
        unsigned perror_v_cmd : 4;
        unsigned perror_v_syn : 8;
        } perror_r_bits;
    int perror_q_whole [2];
    } ;

/*                                                                          */
/* TSUNAMI Pchip Window Space Base Address register.                        */
/*                                                                          */
#define wsba_m_ena 0x1
#define wsba_m_sg 0x2
#define wsba_m_ptp 0x4
#define wsba_m_addr 0xFFF00000
#define wmask_k_sz1gb 0x3FF00000

union TPchipWSBA {
    struct  {
        unsigned wsba_v_ena : 1;
        unsigned wsba_v_sg : 1;
        unsigned wsba_v_ptp : 1;
        unsigned wsba_v_rsvd1 : 17;
        unsigned wsba_v_addr : 12;
        unsigned wsba_v_rsvd2 : 32;
        } wsba_r_bits;
    int wsba_q_whole [2];
};

/*----------------------------------------------------------------------*/
/* Tsunami-specific TIGbus IO routines */
/* These routines can only be accessed by code that _knows_ it is in a  
 * Tsunami system: ie, it can only be called from the platform and northbridge
 * modules */

void tigwb( ui offset, ub data ); 		/* TIG bus access */
ub tigrb( ui offset );


/*----------------------------------------------------------------------*/
/* Tsunami Error-handling private routines */

void pchip_err_analyse_clear( String Analysis, unsigned pchipno );
void cchip_nxm_analyse_clear( String interp );


#endif /* __TSUNAMI_H_LOADED */

