#ifndef DIAGS__INFO_H_LOADED
#define DIAGS__INFO_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* Alpha Diagnostics Hardware Configuration Information Manager */
/* Begun by Stig Telfer, API NetWorks, 22 February 2001 */

/* The concept of this module is to collect known fragments of information 
 * together, remembering something about where they were gathered from and 
 * what they are about.
 *
 * The collated data can then be presented in a uniform way which is intended
 * to be more helpful to the user.
 */

/*------------------------------------------------------------------------*/
/* Data structures and definitions */
enum INFO_SOURCE {
	SRC_SROM,		/* Information passed up by SROM in registers */
	SRC_DIAGS,		/* Information compiled into Diags */
	SRC_CHIPSET,		/* Information from chips on the motherboard */
	SRC_I2C,		/* Information from I2C bus devices */
	SRC_CPU,		/* Information from CPU internal registers */
	SRC_FIRMWARE,		/* Information gathered from the ROM */
	SRC_JUMPERS,		/* Information from jumper configuration */
	SRC_TIG,		/* Information from TIG registers (Tsunami) */
	SRC_MISC		/* Other sources of information */
};


enum INFO_SUBJECT {
	SUBJ_CPU,		/* Data about the processor(s) */
	SUBJ_MEMORY,		/* Data about the memory config */
	SUBJ_FIRMWARE,		/* Data about firmware in the ROM */
	SUBJ_CHIPSET,		/* Data about chips on the motherboard */
	SUBJ_MOTHERBOARD,	/* Data about the motherboard revision */
	SUBJ_MISC,		/* Other subjects of information */
};

/* Don't change the above without changing the below if appropriate */
#define SUBJ_FIRST	SUBJ_CPU		/* first topic in list */
#define SUBJ_LAST	SUBJ_MISC		/* last topic in list */


struct _info_pearl_t;

/* Top level structure - a list of subjects of information */
typedef struct _info_subject_t {
    uint8 subject;			/* matches enum INFO_SUBJECT above */
    struct _info_pearl_t *pearls;	/* associated pearls of wisdom */
    struct _info_subject_t *next;
} info_subject_t;


/* Lower level structure - pearls of wisdom gathered about a given subject */
typedef struct _info_pearl_t {
    uint8 source;			/* matches enum INFO_SOURCE above */
    String attribute;
    String value;
    struct _info_pearl_t *next;
} info_pearl_t;


/* All known hardware configuration data is found here */
extern info_subject_t *info;


/*------------------------------------------------------------------------*/
/* Access functions */
/* (the data structures above may also be directly manipulated) */

/* Add a new piece of information to what is known */
void info_submit( const enum INFO_SOURCE, const enum INFO_SUBJECT,
		  const String Attribute, const String Valuefmt, ... );

/* Dump all known information to the log stream */
void info_log( void );

/* Dump all known information to the tty stream in an interactive way */
DBM_STATUS info_dump( int argc, char *argv[] );

#endif 		/* DIAGS__INFO_H_LOADED */

