/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 *
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *
 *-------------------------------------------------------------------*/
/* HWRPB setup. (Hardware Reset Parameter Block)
 * This routine includes the initialisation of all data structures
 * referenced by the HWRPB, which is defined in the Console Interface section
 * of the Alpha Architecture Reference Manual.
 *
 * The HWRPB is located in the first page of memory.  Given that we are
 * in a 1-1 mapping mode at present, the first virtual page is the first
 * physical page so there's no confusion about that
 */

/* Relevant Systypes defined for API platforms */
#define ST_DEC_TSUNAMI           34     	/* Tsunami systype */

/* Alpha Processor, Inc. systems */
#define ST_API_BIAS             200		/* Offset for API systems */
#define ST_API_NAUTILUS         (ST_API_BIAS+1)	/* Nautilus systype */


/* Flags relating to each processor for communication between console and OS */
/* (See Alpha Architecture Handbook section III p2-21). */

/* Console action requested by system software (on reentry to console) */

#define PERCPU_REASON(flags)	( (flags) >> 16 & 0xFF )
#define 	REASON_DEFAULT	0
#define 	REASON_TERMEXIT	1
#define 	REASON_COLDBOOT	2
#define 	REASON_WARMBOOT	3
#define 	REASON_HALT	4

/* Flags that signify various things on passing between OS and console */

#define PERCPU_PALCODE_LOADED	(1<<8)	/* PALcode is at the address given */
#define PERCPU_MEM_VALID	(1<<7)	/* PALcode mem and scratch addrs good */
#define PERCPU_PAL_VALID	(1<<6)	/* Processor's PALcode is valid */
#define PERCPU_CTX_VALID	(1<<5)	/* HWPCB in this slot is valid */
#define PERCPU_OPR_HALT		(1<<4)	/* Explicit operator action */
#define PERCPU_CPU_PRESENT	(1<<3)	/* CPU physically present in config */
#define PERCPU_CPU_AVAIL	(1<<2)	/* CPU present and available for use */
#define PERCPU_RESTART_CAP	(1<<1)	/* OS may be restarted on this CPU */
#define PERCPU_BIP		(1<<0)	/* Bootstrap in progress */

/* return the flags in full */
uint64 percpu_getflags( const int cpuid );

/* set any bits set in mask, returning the new set of flags */
uint64 percpu_setflags( const int cpuid, const uint64 setmask );

/* clear any bits set in mask, returning the new set of flags */
uint64 percpu_clrflags( const int cpuid, const uint64 clrmask );

/*------------------------------------------------------------------------*/
/* HWRPB data structures and definitions - see Alpha Arch Ref Section III */


/* A basic process descriptor, used for starting the kernel */

typedef struct {
    unsigned long ksp;
    unsigned long usp;
    unsigned long ptbr;
    unsigned int pcc;
    unsigned int asn;
    unsigned long unique;
    unsigned long flags;
    unsigned long res1, res2;
} HWPCB_t;


enum hwrpb_processor_codes {

    HWRPB_CPU_EV3 = 1,
    HWRPB_CPU_EV4 = 2,
    HWRPB_CPU_LCA4 = 4,
    HWRPB_CPU_EV5 = 5,
    HWRPB_CPU_EV45 = 6,
    HWRPB_CPU_EV56 = 7,
    HWRPB_CPU_EV6 = 8,
    HWRPB_CPU_PCA56 = 9,
    HWRPB_CPU_PCA57 = 10,
    HWRPB_CPU_EV67 = 11,
    HWRPB_CPU_EV68 = 12
};


typedef struct {
    uint64 hwpcb[16];
    uint64 flags;
    uint64 pal_mem_size;
    uint64 pal_scratch_size;
    uint64 pal_mem_pa;
    uint64 pal_scratch_pa;
    uint64 pal_revision;
    uint64 type;
    uint64 variation;
    uint64 revision;
    uint64 serial_no[2];
    uint64 logout_area_pa;
    uint64 logout_area_len;
    uint64 halt_PCBB;
    uint64 halt_PC;
    uint64 halt_PS;
    uint64 halt_arg;
    uint64 halt_ra;
    uint64 halt_pv;
    uint64 halt_reason;
    uint64 res;
    uint64 ipc_buffer[21];
    uint64 palcode_avail[16];
    uint64 compatibility;
} perCPU_t;

typedef struct {
    uint64 start_pfn;
    uint64 numpages;
    uint64 numtested;
    uint64 bitmap_va;
    uint64 bitmap_pa;
    uint64 bitmap_chksum;
    uint64 usage;
} memclust_t;

typedef struct {
    uint64 chksum;
    uint64 optional_pa;
    uint64 numclusters;
    memclust_t cluster[0];
} memdesc_t;

typedef struct {
    uint64 phys_addr;        /* check: physical address of the hwrpb */
    uint64 id;               /* check: "HWRPB\0\0\0" */
    uint64 revision;
    uint64 size;             /* size of hwrpb */
    uint64 cpuid;
    uint64 pagesize;         /* 8192, I hope */
    uint64 pa_bits;          /* number of physical address bits */
    uint64 max_asn;
    unsigned char ssn[16];
    uint64 sys_type;
    uint64 sys_variation;
    uint64 sys_revision;
    uint64 intr_freq;        /* interval clock frequency * 4096 */
    uint64 cycle_freq;       /* cycle counter frequency */
    uint64 vptb;             /* Virtual Page Table Base address */
    uint64 res1;
    uint64 tbhb_offset;      /* Translation Buffer Hint Block */
    uint64 nr_processors;
    uint64 processor_size;
    uint64 processor_offset;
    uint64 ctb_nr;
    uint64 ctb_size;         /* console terminal block size */
    uint64 ctbt_offset;      /* console terminal block table offset */
    uint64 crb_offset;       /* console callback routine block */
    uint64 mddt_offset;      /* memory data descriptor table */
    uint64 cdb_offset;       /* configuration data block (or NULL) */
    uint64 frut_offset;      /* FRU table (or NULL) */
    void (*save_terminal)(uint64);
    uint64 save_terminal_data;
    void (*restore_terminal)(uint64);
    uint64 restore_terminal_data;
    void (*CPU_restart)(uint64);
    uint64 CPU_restart_data;
    uint64 res2;
    uint64 res3;
    uint64 chksum;
    uint64 rxrdy;
    uint64 txrdy;
    uint64 dsr_offset;
} HWRPB_t;

extern HWRPB_t *hwrpb;


/* Diags supports the notion that the kernel can leave a little present in 
 * memory that needs to be protected.  Future processing of that present depends
 * on what it is:
 * 1) Firmware ROM image (with valid header please) - load and start that image
 * 2) New kernel (gzipped elf file a la vmlinux.gz) - jump into that kernel
 * 3) MCL crashdump data - don't touch it, reboot, the kernel takes care of it
 */
extern void *hwrpb_bootmem_addr;
extern size_t hwrpb_bootmem_size;

/* This is the mechanism that updates the Diags memory map with any magic 
 * preserved kernel memory (bootmem) */
extern void hwrpb_update_mem_from_hwrpb( void );

/*
 * This should be done once, by the primary CPU.
 */
extern void hwrpb_init();


/*
 * Do we have a HWRPB already intact?
 */
BOOLEAN hwrpb_valid( void );


/*
 * This should be done by each new CPU upon entering diags.
 */
extern void hwrpb_add( const int phys_id );


/*
 * Cause the HWRPB to build its memory map passed up to the OS
 */
extern void hwrpb_update_mem( char *mem_map, int map_pages );

/*
 * Dump the HWRPB configuration - useful for debug
 */
extern void hwrpb_dump( void );

/*
 * Dump the HWRPB memory configuration - useful for debug
 */
extern void hwrpb_dump_memcfg( void );

/*
 * Obtain the HWPCB for a processor
 */
extern HWPCB_t *hwrpb_gethwpcb( int id );


/* 
 * Secondaries - wait for the action signal from a primary processor
 */
extern void hwrpb_await_signal( unsigned long palbase, unsigned long vptbr );

