#ifndef __DBMTYPES_H_LOADED
#define __DBMTYPES_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/*
 * Data type definitions
 * Here...
 *   B = 8 bits,
 *   W = 16 bits,
 *   I = 32 bits,
 *   L = 64 bits
 */
typedef unsigned char ub;
typedef signed char sb;

typedef unsigned short int uw;
typedef signed short int sw;

typedef unsigned int ui;
typedef signed int si;

typedef unsigned long ul;
typedef long sl;


/* Logical type */
typedef ui BOOLEAN;


/* STATUS_WARNING - means a test passed but with caveats */
typedef enum { STATUS_FAILURE, STATUS_SUCCESS, STATUS_WARNING } DBM_STATUS;

typedef char *String;

typedef unsigned char   uint8;
typedef unsigned short  uint16;
typedef unsigned int    uint32;
typedef unsigned long   uint64;

typedef signed char	int8;
typedef signed short	int16;
typedef signed int	int32;
typedef signed long	int64;


typedef volatile unsigned long *SMP_ptr;
typedef DBM_STATUS (*Action_t) ( int argc, char *argv[] );

#endif /* __DBMTYPES_H_LOADED */
