#ifndef __BEEPCODE_H_LOADED
#define __BEEPCODE_H_LOADED
/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

/*
 *  $Id: beepcodes.h,v 1.14 2001/03/09 19:30:33 stig Exp $;
 */

/* The encoding is a morse-style code with 1=dot, 0=dash 
 * note: Beep code format starts at the LSB.  
 * Note: with the current encoding the last bit is an end marker
 */

#define beep_k_mchk		0x0F	/* dot dot dot = machine check */
#define beep_k_vgawarn		0x06	/* dash dot = VGA warning */
#define beep_k_noconsole	0x03	/* dot - no console available */
#define beep_k_diags_err	0x07	/* dot dot - software error */

/* UP2000/UP2000+ halt button was a toggle switch on some early models */
#define beep_k_haltbutton	0x78	/* dash dash dash dot dot dot: SOS! */

/* UP2000/UP2000+ sometimes has a shoddy Cypress with drifting timer circuit */
#define beep_k_rtc_duff		0x1C	/* dash dash dot dot */

/* Motherboard has been put into a dodgy configuration (eg jumpers) */
#define beep_k_hw_mismatch	0x0E	/* dash dot dot */

/* SROM has passed up an inconsistent processor speed calculation */
#define beep_k_srom_miscalc	0x1F	/* dot dot dot dot */

/* A OS-level reboot request was made that failed */
#define beep_k_reboot_timeout	0x06	/* dash dot */
#define beep_k_reboot_failed	0x1A	/* dash dot dash dot */


/* On POST, a system health sensor was found to be beyond its threshold */
#define beep_k_system_health	0x15	/* dot dash dot dash */

/* If the ROM log record is in some way unexpectedly dodgy, you'll hear this */
#define beep_k_romlog_corrupt	0x05	/* dot dash */


#endif /* __BEEPCODE_H_LOADED */
