#ifndef DIAGS__ADM9240_H_LOADED
#define DIAGS__ADM9240_H_LOADED
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* 
 * $Id:
 * Author:
 * 	Stig Telfer 15 September 2000
 */

/* ADM9240 thermal registers: */

#define ADM_TEMP	0x27	/* temperature reading */
#define ADM_TEMP_HLIM	0x39	/* High temperature threshold */
#define ADM_TEMP_HYST	0x3A	/* over-temperature hysteresis value */
#define ADM_TEMP_CFG	0x4B	/* Temperature configuration register */
#define		TEMP_CFG_LSB	(1<<7)	/* LSB of temp reading */
#define		TEMP_CFG_IDFLT	0	/* repeated ints until below hyst */
#define		TEMP_CFG_I1SHOT	1	/* Only one interrupt raised */
#define		TEMP_CFG_ICMP	2	/* continuous assert until below hyst */


/* ADM9240 Voltage measurement registers */
/* The measured values are recorded scaled by their nominal values, so that
 * in each case a reading of 192 (3/4 full scale) is set to be the ideal value
 */

#define ADM_VCCP1_HLIM	0x2D	/* Vccp1 high limit */
#define ADM_VCCP1	0x21	/* Vccp1 measured value */
#define ADM_VCCP1_LLIM	0x2E	/* Vccp1 low limit */

#define ADM_VCCP2_HLIM	0x35	/* Vccp2 high limit */
#define ADM_VCCP2	0x25	/* Vccp2 measured value */
#define ADM_VCCP2_LLIM	0x36	/* Vccp2 low limit */

#define ADM_2_5V_HLIM	0x2B	/* 2.5V high limit */
#define ADM_2_5V	0x20	/* 2.5V measured value */
#define ADM_2_5V_LLIM	0x2C	/* 2.5V low limit */

#define ADM_3_3V_HLIM	0x2F	/* 3.3V high limit */
#define ADM_3_3V	0x22	/* 3.3V measured value */
#define ADM_3_3V_LLIM	0x30	/* 3.3V low limit */

#define ADM_5V_HLIM	0x31	/* 5V high limit */
#define ADM_5V		0x23	/* 5V measured value */
#define ADM_5V_LLIM	0x32	/* 5V low limit */

#define ADM_12V_HLIM	0x33	/* 12V high limit */
#define ADM_12V		0x24	/* 12V measured value */
#define ADM_12V_LLIM	0x34	/* 12V low limit */


/* ADM9240 Fan monitoring details */

#define ADM_FAN1	0x28	/* Fan 1 RPM */
#define ADM_FAN1_HLIM	0x3B	/* High threshold for fan 1 period */
#define ADM_FAN2	0x29	/* Fan 2 RPM */
#define ADM_FAN2_HLIM	0x3C	/* High threshold for fan 2 period */
#define ADM_FDIV	0x47	/* Fan divisor register & Pentium VID 0-3 */

#define 	FDIV_FAN1_MASK	(3<<4)
#define		FDIV_FAN1_1	(0<<4)		/* Fan 1 divisor = 1, 8800rpm */
#define		FDIV_FAN1_2	(1<<4)		/* Fan 1 divisor = 2, 4400rpm */
#define		FDIV_FAN1_4	(2<<4)		/* Fan 1 divisor = 4, 2200rpm */
#define		FDIV_FAN1_8	(3<<4)		/* Fan 1 divisor = 8, 1100rpm */
#define 	FDIV_FAN2_MASK	(3<<6)
#define		FDIV_FAN2_1	(0<<6)		/* Fan 2 divisor = 1, 8800rpm */
#define		FDIV_FAN2_2	(1<<6)		/* Fan 2 divisor = 2, 4400rpm */
#define		FDIV_FAN2_4	(2<<6)		/* Fan 2 divisor = 4, 2200rpm */
#define		FDIV_FAN2_8	(3<<6)		/* Fan 2 divisor = 8, 1100rpm */


/* Miscellaneous configuration registers */

#define ADM_CFG		0x40	/* configuration register */
#define		CFG_START	(1<<0)		/* 1=start operation */
#define		CFG_INTEN	(1<<1)		/* 1=interrupt enable */
#define		CFG_INTCLR	(1<<3)		/* 1=clear previous int */
#define		CFG_RESET	(1<<4)		/* 1=pulse reset 20msec */
#define		CFG_CIRESET	(1<<6)		/* Chassis intrusion stuff */
#define 	CFG_INIT	(1<<7)		/* 1=restore CSR defaults */

#define ADM_INT1	0x41	/* Interrupt status register 1 */
#define 	INT1_2_5V	(1<<0)		/* 2.5V out of spec */
#define 	INT1_VCCP1	(1<<1)		/* Vccp1 out of spec */
#define 	INT1_3_3V	(1<<2)		/* 3.3V out of spec */
#define 	INT1_5V		(1<<3)		/* 5V out of spec */
#define 	INT1_TEMP	(1<<4)		/* Temperature out of spec */
#define 	INT1_FAN1	(1<<6)		/* Fan 1 RPM out of spec */
#define 	INT1_FAN2	(1<<7)		/* Fan 2 RPM out of spec */

#define ADM_INT2	0x42	/* Interrupt status register 2 */
#define		INT2_12V	(1<<0)		/* 12V out of spec */
#define		INT2_VCCP2	(1<<1)		/* Vccp2 out of spec */
#define		INT2_CHASSIS	(1<<4)		/* Intruder detect triggered */

#define	ADM_INTMASK1	0x43	/* Interrupt mask register 1 */
#define		MASK1_2_5V	(1<<0)		/* 1=disable 2.5V alert */
#define		MASK1_VCCP1	(1<<1)		/* 1=disable Vccp1 alert */
#define		MASK1_3_3V	(1<<2)		/* 1=disable 3.3V alert */
#define		MASK1_5V	(1<<3)		/* 1=disable 5V alert */
#define		MASK1_TEMP	(1<<4)		/* 1=disable Temp alert */
#define		MASK1_FAN1	(1<<6)		/* 1=disable Fan 1 alert */
#define		MASK1_FAN2	(1<<7)		/* 1=disable Fan 2 alert */

#define	ADM_INTMASK2	0x44	/* Interrupt mask register 2 */
#define		MASK2_12V	(1<<0)		/* 1=disable 12V alert */
#define		MASK2_VCCP2	(1<<1) 		/* 1=disable Vccp2 alert */
#define		MASK2_CHASSIS	(1<<4)		/* 1=disable chassis alert */
#define		MASK2_RESET	(1<<7)		/* 1=enable reset function */

#define ADM_COMPAT	0x45	/* Reserved Compatibility register */
#define ADM_CHASSIS	0x46	/* Chassis intrustion clear register */

#define ADM_VID4	0x49	/* Pentium VID 4 register */
#define ADM_SADDR	0x48	/* 7-bit I2C address of this device (RW) */
#define ADM_ANALOG_OUT	0x19	/* Programmed value of analog output */
#define ADM_TEST	0x15	/* don't use */
#define ADM_ID		0x3E	/* contains 0x23 for ADM9240 */

/*------------------------------------------------------------------------*/
/* Public data structures */

/* All measured quantities from an ADM9240 */
typedef struct {

    uint8 temp;		/* temperature (x2) */
    uint8 chassis;	/* 1=chassis intrusion */
    uint16 v2_5;	/* 2.5V (x100) */
    uint16 v3_3;	/* 3.3V (x100) */
    uint16 v5;		/* 5V (x100) */
    uint16 v12;		/* 12V (x100) */
    uint16 vccp1;	/* Vccp1 (x100) */
    uint16 vccp2;	/* Vccp2 (x100) */
    uint16 fan1;	/* Fan 1 RPM */
    uint16 fan2;	/* Fan 2 RPM */

} adm9240_t;


/*------------------------------------------------------------------------*/
/* Functions */

/* initialise controller (with all devices disabled) */
DBM_STATUS adm_init( uint8 addr );

/* enable one sensor channel (done between init and start) */
/* Allowable arguments are:
 * sens		initialisation parameters 
 * ----		-------------------------
 * TEMP0	temp_max, temp_hyst
 * FAN0		nominal_rpm, minimum_rpm
 * FAN1		nominal_rpm, minimum_rpm
 */
DBM_STATUS adm_add_dev( uint8 A, i2c_sensor sens, ... );

/* Once configured, a controller starts sampling when invoked here */
DBM_STATUS adm_start( uint8 addr );


DBM_STATUS adm_therm_read( uint8 addr, i2c_therm_t *T );
DBM_STATUS adm_fan_read( uint8 addr, const i2c_sensor sens, i2c_fan_t *T );
DBM_STATUS adm_voltages( uint8 addr, const i2c_sensor sens, i2c_volt_t *T );

DBM_STATUS adm_get( uint8 addr, adm9240_t *adm );

#endif 		/* DIAGS__ADM9240_H_LOADED */
