/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/* I2C bus test applet 	                              		      */
/* (c) 1999 Alpha Processor Inc.                                      */
/* Begun by Stig Telfer, API, 1 September 1999			      */

#undef TRACE_ENABLE

#include "lib.h"
#include "uilib.h"

#include "i2c.h"
#include "i2c/adm9240.h"
#include "platform.h"

#define DEFAULT_ITERS 10

/*--------------------------------------------------------------------*/
/* The problem with all this I2C stuff is that it is quite variable from
 * platform to platform so we need to refer to it all in an abstract way
 */


DBM_STATUS i2c( int argc, char *argv[] )
{
    char buf[64], desc[80];
    DBM_STATUS sval = STATUS_SUCCESS;
    const I2Cbus_t *I;
    int i, n=DEFAULT_ITERS;
    int sensorsOK = TRUE;
    int rval;

    TRACE( "Running i2cinit...\n" );
    plat_i2cinit();

    /* paranoia */
    if ( plat_i2c_bus == NULL )
        return STATUS_SUCCESS;

    /* read an optional number of iterations as command line argument */
    if ( argc > 1 )
	n = atoi( argv[1] );

    diags_subsys_stat( SYS_I2C, DEV_STRESSING );

    for ( i=0; i<n && sensorsOK; i++ )
    {
        /* Take a look at all the devices available */
        mobo_cls();
        for( I=plat_i2c_bus; I->dev != I2C_NODEV; I++ )
        {
            TRACE( "Examining %d %d %d (%s)\n",
                I->dev, I->sensor, I->chip, I->desc );
	    sval = i2c_status( I, buf );

	    switch( sval )
	    {
		/* A failure from the I2C suggests something is dud */
		case STATUS_FAILURE:
		    mobo_logf( LOG_CRIT "Failure on reading device %s\n",
			    I->desc );
		    rval = mobo_alertf( "I2C Read Failure",
			"Failure on reading device %s on test pass %d\r"
			"Press 'q' to quit now, or any other key to continue",
				    I->desc, i );
		    if ( isalpha( rval ) && tolower( rval ) == 'q' )
		    {
			diags_subsys_stat( SYS_I2C, DEV_FAILED );
			return STATUS_FAILURE;
		    }

		    /* make this the last lap */
		    sensorsOK = FALSE;
		    sprintf_dbm( desc, "%-30s: reading failed!", I->desc );
		    break;

		/* A warning from the I2C suggests something's beyond spec */
	    	case STATUS_WARNING:
		    mobo_logf( LOG_WARN "I2C: "
			"Sensor '%s' is operating out of its valid range!\n",
			I->desc );
		    mobo_alertf( "I2C Sensor Warning",
			"Sensor monitoring '%s'\r"
			"is operating outside of its valid range", I->desc );

		    /* make this the last lap */
		    sensorsOK = FALSE;

		    /* Drop through for print (we still got good data out) */
		default:
		case STATUS_SUCCESS:
		    sprintf_dbm( desc, "%-30s: %s", I->desc, buf );
		    break;
	    }

	    /* Only put the first pass on the record for brevity */
	    if ( i == 0 )
		mobo_logf( LOG_INFO "%s\n", desc );

	    printf_dbm("%s\r", desc );
        }

	/* For interactive mode there's the option for breaking in here */
	if( mobo_key( 500 ) != -1 )
	    break;
    } 

    printf_dbm( "\n%d Test passes completed %s.\n",
	i, sensorsOK ? "successfully" : 
	"with sensors failing or working out of range" );
    mobo_key( 0 );

    diags_subsys_stat( SYS_I2C, sensorsOK ? DEV_PASSED : DEV_FAILED );
    
    return sval;
}

