/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/


#include "lib.h"
#include "northbridge.h"
#include "uart.h"


/* service offsets for use with comm port base addresses */

#define com_Rbr     0   /* Receive Buffer Register Offset */
#define com_Thr     0   /* Xmit Holding Register Offset */
#define com_Ier     1   /* Interrupt Enable Register Offset */
#define com_Iir     2   /* Interrupt ID Register Offset */
#define com_Lcr     3   /* Line Control Register Offset */
#define com_Mcr     4   /* Modem Control Register Offset */
#define com_Lsr     5   /* Line Status Register Offset */
#define com_Msr     6   /* Modem Status Register Offset */
#define com_Scr     7   /* Scratch Register Offset */
#define com_Dll     0   /* Divisor Latch (LS) Offset */
#define com_Dlm     1   /* Divisor Latch (MS) Offset */

/* modem control bits */
#define com_DTR     0x01
#define com_RTS     0x02

/* line control bits */
#define com_WLS     0x03 
#define com_5BW     0x00 
#define com_6BW     0x01
#define com_7BW     0x02
#define com_8BW     0x03

#define com_STB     0x04
#define com_1SB     0x04
#define com_2SB     0x00

#define com_PEN     0x08    /* parity enable */
#define com_EPE     0x10    /* even parity enable (otherwise odd) */


#define com_DLAB    0x80    /* Divisor latch enable bit */


/* base addresses for comm ports */
static int dev2base( io_dev D )
{
    switch ( D ) {
	case DEV_COM1:	return 0x3F8;
	case DEV_COM2:	return 0x2F8;
	case DEV_COM3:	return 0x3E8;
	case DEV_COM4:	return 0x2E8;
	default:
    }
    return -1;
}


/*--------------------------------------------------------------------------
 * Initialize the Comm port at the specified address and baud rate.
 * Returns STATUS_FAILURE if the port does not exist else STATUS_SUCCESS
 *-------------------------------------------------------------------------*/

DBM_STATUS UartInitLine( io_dev D, int baud)
{
    int i;
    int baudconst;

    int PortBase = dev2base( D );
    if ( PortBase == -1 ) 	return STATUS_FAILURE;

    switch (baud)
    {
    case 115200:baudconst =   1; break;
    case 57600: baudconst =   2; break;
    case 38400: baudconst =   3; break;
    case 19200: baudconst =   6; break;
    default:
    case 9600:	baudconst =  12; break;
    case 7200:  baudconst =  16; break;
    case 4800:	baudconst =  24; break;
    case 2400:	baudconst =  48; break;
    case 1200:	baudconst =  96; break;
    case 300:	baudconst = 384; break;
    case 150:	baudconst = 768; break;
    }

    outportb(PortBase+com_Lcr, 0x87);
    if( inportb(PortBase+com_Lcr) != 0x87 )
	return( STATUS_FAILURE );
    outportb(PortBase+com_Dlm, 0);
    outportb(PortBase+com_Dll, baudconst);
    outportb(PortBase+com_Lcr, 0x07);
    if( inportb(PortBase+com_Lcr) != 0x07 )
	return( STATUS_FAILURE );
    outportb(PortBase+com_Mcr, 0x0F);

    for(i=10;i>0 && inportb(PortBase+com_Lsr) != (ui)0;i--)
	inportb(PortBase+com_Rbr);

    return( STATUS_SUCCESS );
}


BOOLEAN UartCharAv( int PortBase )
{
    return (inportb(PortBase+com_Lsr) & 1) ? TRUE : FALSE;
}


int UartGetChar( io_dev D )
{
    int PortBase = dev2base( D );
    if ( PortBase == -1 )		return -1;

#ifdef CONFIG_SHARK

   /* Shark platform shares COM port connectors with SROM connectors, so we 
    * need to be able to switch between them */

    shark_serial_select( SHARK_COM ); 

#endif

    if ( !UartCharAv( PortBase ) )	return -1;	/* no char to get */

    return((char)inportb(PortBase+com_Rbr) & 0x0FFU);
}


/*--------------------------------------------------------------------------
 * Read the next character from the port waiting if necessary.
 * Returns: 1 if a character is read, 0 if it timed out.
 *-------------------------------------------------------------------------*/

char UartGetNextChar(
    int	    PortBase,	/* IO Port address */
    char *  c,		/* Address to store the character read */
    int	    WaitLimit)	/* Wait limit in miliseconds */
{
    long Waited = 0;
    long FullWaitLimit = 1000 * WaitLimit;
    do
    {
	if( UartCharAv( PortBase ) )
	{
	    *c = UartGetChar( PortBase );
	    return( 1 );
	}

	if( Waited >= FullWaitLimit )
	    return( 0 );

	usleep(80);	/* at 115.2K baud chars are ~86us apart */
	Waited += 80;
    }
    while( 1 );
}


void UartPutChar( io_dev D, char c )
{ 
    int PortBase = dev2base( D );
    if ( PortBase == -1 )	return;

#ifdef CONFIG_SHARK

   /* Shark platform shares COM port connectors with SROM connectors, so we 
    * need to be able to switch between them */

    shark_serial_select( SHARK_COM ); 

#endif

    while ((inportb(PortBase + com_Lsr) & 0x20) == 0)
        usleep(50);

    outportb(PortBase + com_Thr,(ui)c);
}


/*--------------------------------------------------------------------------
 * Read all available characters from the port
 *-------------------------------------------------------------------------*/

void UartFlushReadBuffer( int PortBase )
{
    while( UartCharAv( PortBase ) )
	UartGetChar( PortBase );
}

#if 0
void putcLpt(int c)
{
   int i;
   while(!(inportb(lptSr) & 0x80))
	;
   for(i=0;i<lptDly;++i)
	;

   outportb(lptDr,    c);

   for(i=0;i<lptDly;++i)
	;

   outportb(lptCr,   lptnInit|lptSTB|lptAFD);

   for(i=0;i<lptDly;++i)
	;

   outportb(lptCr,   lptnInit|lptAFD);

   for(i=0;i<lptDly;++i)
	;

   (void)inportb(lptSr);
}
#endif


