/*****************************************************************************

       Copyright  1993, 1994 Digital Equipment Corporation,
                       Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, provided  
that the copyright notice and this permission notice appear in all copies  
of software and supporting documentation, and that the name of Digital not  
be used in advertising or publicity pertaining to distribution of the software 
without specific, written prior permission. Digital grants this permission 
provided that you prominently mark, as not part of the original, any 
modifications made to this software or documentation.

Digital Equipment Corporation disclaims all warranties and/or guarantees  
with regard to this software, including all implied warranties of fitness for 
a particular purpose and merchantability, and makes no representations 
regarding the use of, or the results of the use of, the software and 
documentation in terms of correctness, accuracy, reliability, currentness or
otherwise; and you rely on the software, documentation and results solely at 
your own risk. 

******************************************************************************/
/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

/* The Beep codes are now encoded in a quirky morse code:
 * 1=dot, 0=dash, starting at the LSB */


#include "lib.h"
#include "time.h"
#include "northbridge.h"

void tone(int period,int duration)
{
  outportb(0x43, 0xB6 );
  outportb(0x42, period & 0xff);
  outportb(0x42, (period >> 8) & 0xff);
  msleep(duration);
  outportb(0x43, 0xb2);
  outportb(0x42, 0);
  outportb(0x42, 0);
}

void Beep(int msec,int freq)
{
  freq = 1193180/freq;

  outportb(0x61, inportb(0x61)|0x03);  /* turn on gate and speaker data for counter 2 */
  tone(freq,msec);
  outportb(0x61, inportb(0x61)&(~0x03));  /* turn off gate and speaker data for counter 2 */
}

#define DOTLEN	100			/* in msec */
#define DASHLEN 200

void BeepCode(int code)
{
#ifdef USE_BEEPS
    do {
	if ( code & 0x1 ) {
	    Beep( DOTLEN, 1024 );
	    msleep( DOTLEN );
	} else {
	    Beep( DASHLEN, 1024 );
	    msleep( DASHLEN );
	}
	code >>= 1;		/* shift down a bit */
    } while ( code != 1 );	/* note: last bit is an end marker */
#endif		/* USE_BEEPS */
}

