/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

#undef TRACE_ENABLE

#include "lib.h"
#include "northbridge.h"
#include "uilib.h"

#include "tabledriver.h"

/* Decoding macros for converting a sequence of bytes into words, longs etc. */
#define DEC8( T )	((unsigned)*(T) & 0xFFU)
#define DEC16( T )	(  DEC8( T ) <<  8 |  DEC8( T + 1 ) )
#define DEC32( T )	( DEC16( T ) << 16 | DEC16( T + 2 ) )

void TblWrite( const TblArray *T )
{
    unsigned val;
    unsigned addr;
    unsigned bus, dev, fun, reg;

    TRACE( "Running...\n" );

    while( *T != OP_EOT )
    {
	switch( *T++ )
	{
	    /* PCI IO-port operations */
	    case OP_IOW8:
		addr = DEC16( T );
		val = DEC8( T + 2 );
		TRACE( "IO write 0x%04X->0x%02X\n", addr, val );
		outportb( addr, val );
		T += 3;
		break;

	    case OP_IOW16:
		addr = DEC16( T );
		val = DEC16( T + 2 );
		TRACE( "IO write 0x%04X->0x%04X\n", addr, val );
		outportw( addr, val );
		T += 4;
		break;

	    case OP_IOW32:
		addr = DEC16( T );
		val = DEC32( T + 2 );
		TRACE( "IO write 0x%04X->0x%08X\n", addr, val );
		outportl( addr, val );
		T += 6;
		break;


	    /* PCI Memory operations */
	    case OP_MEMW8:
		addr = DEC32( T );
		val = DEC8( T + 4 );
		TRACE( "PCI mem write 0x%08X->0x%02X\n", addr, val );
		outmemb( addr, val );
		T += 5;
		break;

	    case OP_MEMW16:
		addr = DEC32( T );
		val = DEC16( T + 4 );
		TRACE( "PCI mem write 0x%08X->0x%04X\n", addr, val );
		outmemw( addr, val );
		T += 6;
		break;

	    case OP_MEMW32:
		addr = DEC32( T );
		val = DEC32( T + 4 );
		TRACE( "PCI mem write 0x%08X->0x%08X\n", addr, val );
		outmeml( addr, val );
		T += 8;
		break;


	    /* PCI CSR operations */
	    case OP_CFGW8:
		bus = DEC8( T );
		dev = DEC8( T + 1 );
		fun = DEC8( T + 2 );
		reg = DEC8( T + 3 );
		val = DEC8( T + 4 );
		TRACE("CSR write\n");
		pcicfgwb( bus, dev, fun, reg, val );
		T += 5;
		break;

	    case OP_CFGW16:
		bus = DEC8( T );
		dev = DEC8( T + 1 );
		fun = DEC8( T + 2 );
		reg = DEC8( T + 3 );
		val = DEC16( T + 4 );
		TRACE("CSR write\n");
		pcicfgww( bus, dev, fun, reg, val );
		T += 6;
		break;

	    case OP_CFGW32:
		bus = DEC8( T );
		dev = DEC8( T + 1 );
		fun = DEC8( T + 2 );
		reg = DEC8( T + 3 );
		val = DEC32( T + 4 );
		TRACE("CSR write\n");
		pcicfgwl( bus, dev, fun, reg, val );
		T += 8;
		break;

	    /* Set marked bits in bytes, words, longs in PCI config space */
	    case OP_CFGS8:
		bus = DEC8( T );
		dev = DEC8( T + 1 );
		fun = DEC8( T + 2 );
		reg = DEC8( T + 3 );
		val = pcicfgrb( bus, dev, fun, reg );
		val |= DEC8( T + 4 );
		TRACE("CSR set\n");
		pcicfgwb( bus, dev, fun, reg, val );
		T += 5;
		break;

	    case OP_CFGS16:
		bus = DEC8( T );
		dev = DEC8( T + 1 );
		fun = DEC8( T + 2 );
		reg = DEC8( T + 3 );
		val = pcicfgrw( bus, dev, fun, reg );
		val |= DEC16( T + 4 );
		TRACE("CSR set\n");
		pcicfgww( bus, dev, fun, reg, val );
		T += 6;
		break;

	    case OP_CFGS32:
		bus = DEC8( T );
		dev = DEC8( T + 1 );
		fun = DEC8( T + 2 );
		reg = DEC8( T + 3 );
		val = pcicfgrl( bus, dev, fun, reg );
		val |= DEC32( T + 4 );
		TRACE("CSR set\n");
		pcicfgwl( bus, dev, fun, reg, val );
		T += 8;
		break;


	    /* Clear marked bits in PCI config space byte */
	    case OP_CFGC8:
		bus = DEC8( T );
		dev = DEC8( T + 1 );
		fun = DEC8( T + 2 );
		reg = DEC8( T + 3 );
		val = pcicfgrb( bus, dev, fun, reg );
		val &= ~DEC8( T + 4 );
		TRACE("CSR clear\n");
		pcicfgwb( bus, dev, fun, reg, val );
		T += 5;
		break;

	    default:		/* no match - somethings wrong! */
		mobo_logf( LOG_CRIT "ERROR: corrupt or unterminated table!\n");	
		return;
	}
    }
}
