/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/

#include "lib.h"		/* debug monitor */
#include "uilib.h"


static void usage( String name )
{
    mobo_alertf("Usage",
		"To set a new ipl: %s <ipl-dec>\r"
		"Where ipl is a value between 0 and 7",
		name );
}

/* enable/disable/show current IPL of interrupts */
DBM_STATUS ipl( int argc, char *argv[] )
{
    int ipl;
    DBM_STATUS sval;

    /* look for command line arguments */
    switch (argc) 
    {
	case 1:						/* print */
	    ipl = swpipl(7);
	    mobo_alertf("Current IPL", "Interrupt level = %d\n", ipl);
	    swpipl(ipl);
	    sval = STATUS_SUCCESS;
	    break;

	case 2:
	    ipl = atoi( argv[1] );

	    if ( ipl >= 0 && ipl <= 7 )
	    {
		swpipl( ipl );
		sval = STATUS_SUCCESS;
	    } else {
		usage( argv[0] );
		sval = STATUS_FAILURE;
	    }
	    break;

	default:
	    usage( argv[0] );
	    sval = STATUS_FAILURE;
	    break;
    }
    return sval;
}
