/*---------------------------------------------------------------------
 *        [ Copyright (c) 1999 Alpha Processor Inc.] - Unpublished Work
 *          All rights reserved
 * 
 *    This file contains source code written by Alpha Processor, Inc.
 *    It may not be used without express written permission. The
 *    expression of the information contained herein is protected under
 *    federal copyright laws as an unpublished work and all copying
 *    without permission is prohibited and may be subject to criminal
 *    and civil penalties. Alpha Processor, Inc.  assumes no
 *    responsibility for errors, omissions, or damages caused by the use
 *    of these programs or from use of the information contained herein.
 *  
 *-------------------------------------------------------------------*/
/*----------------------------------------------------------------------*/
/* CPU revision definitions */

extern const String EV6_rev[];
String ev6_cpurev( unsigned long I_CTL );


#define EV6__EV6_REVBASE	0		/* returned by ev6_cpurevno */
#define EV6__EV67_REVBASE	8
#define EV6__EV68_REVBASE	16

int ev6_cpurevno( unsigned long I_CTL );



/*----------------------------------------------------------------------*/
/* IPR structures for EV6, containing the necessary data for the 
 * machine check handler to unpick the logout frame
 */


/* I_STAT */

#define EV6__I_STAT__PAR		( 1 << 29 )


/* MM_STAT */

#define EV6__MM_STAT__DC_TAG_PERR	( 1 << 10 )


/* DC_STAT */

#define EV6__DC_STAT__SEO		( 1 << 4 )
#define EV6__DC_STAT__ECC_ERR_LD	( 1 << 3 )
#define EV6__DC_STAT__ECC_ERR_ST	( 1 << 2 )
#define EV6__DC_STAT__TPERR_P1		( 1 << 1 )
#define EV6__DC_STAT__TPERR_P0		( 1      )


/* C_STAT */

#define EV6__C_STAT__BC_PERR		( 0x01 ) 
#define EV6__C_STAT__DC_PERR		( 0x02 )
#define EV6__C_STAT__DSTREAM_MEM_ERR	( 0x03 )
#define EV6__C_STAT__DSTREAM_BC_ERR	( 0x04 )
#define EV6__C_STAT__DSTREAM_DC_ERR	( 0x05 )
#define EV6__C_STAT__PROBE_BC_ERR	( 0x06 )
#define EV6__C_STAT__ISTREAM_MEM_ERR	( 0x0B )
#define EV6__C_STAT__ISTREAM_BC_ERR	( 0x0C )
#define EV6__C_STAT__DSTREAM_MEM_DBL	( 0x13 )
#define EV6__C_STAT__DSTREAM_BC_DBL	( 0x14 )
#define EV6__C_STAT__ISTREAM_MEM_DBL	( 0x1B )
#define EV6__C_STAT__ISTREAM_BC_DBL	( 0x1C )


/* I_SUM */

#define EV6__I_SUM__INT0		( 1UL << 33 )
#define EV6__I_SUM__INT1		( 1UL << 34 )
#define EV6__I_SUM__INT2		( 1UL << 35 )
#define EV6__I_SUM__INT3		( 1UL << 36 )
#define EV6__I_SUM__INT4		( 1UL << 37 )
#define EV6__I_SUM__INT5		( 1UL << 38 )
