/*
 * transformation functions
 */
#include "gks.h"
/* define things from gks_types to avoid conflicts with lib.h */
#define REAL Gfloat
typedef REAL NDC;		/* normalized display coordinates */

typedef struct
{
	NDC	ndc_x;
	NDC	ndc_y;
}		NDCPT;			/* NDC point */

typedef REAL WC;		/* world coordinates */

typedef struct
{
	WC		wc_x;
	WC		wc_y;
}		WCPT;			/* WC point */

typedef REAL TWODTRANS[2][3];

/*
 *	compose transformation matrix
 *
 *	cx, cy		=	center point for scale/rotate
 *	sx, sy		=	scale factors
 *	sinx, cosx	=	sine/cosine of rotation angle
 *	fx, fy		=	final position
 */
CompTr(t, cx, cy, sx, sy, sinx, cosx, fx, fy)
	register TWODTRANS t;
	REAL	cx, cy;
	REAL	sx, sy;
	REAL	sinx, cosx;
	REAL	fx, fy;
{
	REAL	sxs, sxc;
	REAL	sys, syc;

	sxs = sx * sinx;
	sxc = sx * cosx;
	sys = sy * sinx;
	syc = sy * cosx;

	t[0][0] = sxc;
	t[0][1] = -sys;
	t[0][2] = cy * sys - cx * sxc + fx;

	t[1][0] = sxs;
	t[1][1] = syc;
	t[1][2] = fy - cx * sxs - cy * syc;
}


/*
 * transform world coordinate to NDC
 */

_wc2ndc(wcpt, ndcpt)
	WCPT   *wcpt;
	NDCPT  *ndcpt;
{
	Gint	tnr;
	Gint	error;

	ginqcurntrannum(&tnr, &error);
	if (error)
		{
		printf("error in _wc2ndc\n");
		return error;
		}
	ndcpt->ndc_x = wcpt->wc_x;
	ndcpt->ndc_y = wcpt->wc_y;
	qzw2nc(tnr, 1, &ndcpt->ndc_x, &ndcpt->ndc_y);
	return 0;
}

/*
 * transform NDC point to WC
 */

#include "lib.h"
#include "gks.cm"
_ndc2wc(norm, ndcpt, wcpt)
	int	norm;
	NDCPT  *ndcpt;
	WCPT   *wcpt;
{
	Gfloat	tempx, tempy;

	wcpt->wc_x = ndcpt->ndc_x;
	wcpt->wc_y = ndcpt->ndc_y;

	tempx = (wcpt->wc_x - qcxfmn.tnrwx0[norm]) / qcxfmn.tnrwxs[norm];
	tempy = (wcpt->wc_y - qcxfmn.tnrwy0[norm]) / qcxfmn.tnrwys[norm];
	wcpt->wc_x = tempx;
	wcpt->wc_y = tempy;
	return (0);
}
