#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/inputmsg.h>

#include <gks/trace.h>

#include "wsinfo.h"

/*
 *	sample input processing
 */
GKSERR _smp_all( fname, wkid, devno, class, result )
	char *fname;
	WKID wkid;
	int  devno;
	INPUTCLASS class;
	struct rpinpsmp **result;
	{
	int res;
	int wscat;
	register struct msinpsmp *msg;
	struct rpinpsmp *reply;
	register WSINFO ws;

#ifdef TRACE
	if(Gksdebug & DB_INPUT)
		Gksout("%s(%d, %d)\n", fname, wkid, devno);
#endif

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
		return(err_hand(7, fname));

	if(wkid == 0)
		return(err_hand(20, fname));

	/*
	 *	deliver "sample <class>" message
	 */
	ws = WsId2info(wkid);
	if(ws == NULL)
		return(err_hand(25, fname));

	wscat = WsGetcat(ws);

	if (class == PICK && wscat != WSC_OUTIN)
		return (err_hand(37, fname));

	if((wscat != WSC_INPUT) && (wscat != WSC_OUTIN))
		return(err_hand(38, fname));

	msg = (struct msinpsmp *)_allocmsg(sizeof(struct msinpsmp));
	if(msg == NULL)
		return(err_hand(904, fname));

	msg->mhdr.msg_id = MSINPSMP;
	msg->mhdr.msg_to = WsGetpid(ws);
	msg->mhdr.msg_length = sizeof(struct msinpsmp) - sizeof(MSGHDR);
	msg->mhdr.msg_ack = TRUE;
	msg->mhdr.msg_reply = 0;
	msg->inpcls = class;
	msg->inpdevno = devno;

	_sendmsg((char *)msg);

	/*
	 *	wait for reply
	 */
	reply = (struct rpinpsmp *)_recvmsg(WsGetpid(ws));
	if(reply == NULL)
		return (err_hand(WsNomsg(), fname));

	/*
	 *	map workstation reply to GKS error number
	 */
	switch(reply->mhdr.msg_reply)
		{
		case 0:		/* success */
			res = 0;
			break;

		case 1:		/* device not in sample mode */
			res = 142;
			break;

		case 2:		/* device not present */
			res = 140;
			break;

		case 3:		/* device present but not ready */
			res = 1015;
			break;

		default:
			Gksout("gks internal error: bad reply to %s.\n", fname);
			Gksout("\twkid = %d, reply = %d\n", wkid, reply->mhdr.msg_reply);
			res = 0;
		}

	if(res != 0)
		{
		_freemsg(reply);
		return(err_hand(res, fname));
		}

	*result = reply;

	return (0);

	}
