#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qwsinfo.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire deferral and update states
 */
VOID
q_ws_def(wkid, errno, def, irg, empty, newframe)
WKID wkid ;
GKSERR *errno ;
DEFMODE *def ;
IRGMODE *irg ;
BOOL *empty ;
BOOL *newframe ;
{
	static char *fname = "q_ws_deff" ;
	WSINFO ws ;
	struct msqwsinf *msg ;
	struct rpqwsinf *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqwsinf *)_allocmsg(sizeof(struct msqwsinf)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	wsinfmsg(msg, WsGetpid(ws)) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct rpqwsinf *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	
	*def = reply -> qs_info.ws_def ;
	*irg = reply -> qs_info.ws_irg ;
	*empty = reply -> qs_info.ws_empty ;
	*newframe = reply -> qs_info.ws_newframe ;
	*errno = 0 ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %d)\n", fname, wkid, *errno,
					*def, *irg, *empty, *newframe) ;
#endif
}

wsinfmsg(msg, pid)
struct msqwsinf *msg ;
PID pid ;
{
	msg -> mhdr.msg_id = MSQWSINF ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = 0 ;
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
}

static char *SccsId = "@(#)q_ws_def.c	1.5\t2/21/85" ;
