#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qtxrep.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire text representation
 */
VOID
q_ws_txr(wkid, index, as_set, errno, font, prec, chexp, space, color)
WKID wkid ;
int index ;
BOOL as_set ;
GKSERR *errno ;
int *font ;
TPREC *prec ;
REAL *chexp ;
REAL *space ;
COLOR *color ;
{
	static char *fname = "q_ws_txr" ;
	WSINFO ws ;
	struct msqtxr *msg ;
	struct msqtxr *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqtxr *)_allocmsg(sizeof(struct msqtxr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	txrmsg(msg, WsGetpid(ws), index, as_set, TRUE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqtxr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 68 ;
			_freemsg(reply) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*font = reply -> qtx_txrep.tx_font ;
	*prec = reply -> qtx_txrep.tx_prec ;
	*chexp = reply -> qtx_txrep.tx_chexp ;
	*space = reply -> qtx_txrep.tx_space ;
	*color = reply -> qtx_txrep.tx_col ;
	*errno = 0 ;
	_freemsg(reply) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %d, %d, %f, %f, %d)\n", fname, wkid, index,
					as_set, *errno, *font, *prec, *chexp, *space, *color) ;
#endif
}

/*
 * inquire default text representation
 */
VOID
q_wd_txr(wktype, index, errno, font, prec, chexp, space, color)
WSTYPE wktype ;
int index ;
GKSERR *errno ;
int *font ;
TPREC *prec ;
REAL *chexp ;
REAL *space ;
COLOR *color ;
{
	static char *fname = "q_wd_txr" ;
	WSINFO ws ;
	struct msqtxr *msg ;
	struct msqtxr *reply ;
	BOOL must_close = FALSE ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
/*
 * see if workstation of specified type is already open.
 */
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return;
		}
/***********************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/***********************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
***********************************************************************/
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		if(must_close)
			close_ws(0xffff) ;
		return ;
	}

	msg = (struct msqtxr *)_allocmsg(sizeof(struct msqtxr)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	txrmsg(msg, WsGetpid(ws), index, TRUE, FALSE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqtxr *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 68 ;
			_freemsg(reply) ;
			if(must_close)
				close_ws(0xffff) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*font = reply -> qtx_txrep.tx_font ;
	*prec = reply -> qtx_txrep.tx_prec ;
	*chexp = reply -> qtx_txrep.tx_chexp ;
	*space = reply -> qtx_txrep.tx_space ;
	*color = reply -> qtx_txrep.tx_col ;
	_freemsg(reply) ;
	if(must_close)
		close_ws(0xffff) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %d, %d, %f, %f, %d)\n", fname, wktype, index,
					*errno, *font, *prec, *chexp, *space, *color) ;
#endif
}

static
txrmsg(msg, pid, index, as_set, fromstate)
struct msqtxr *msg ;
PID pid ;
int index ;
BOOL as_set ;
BOOL fromstate ;
{
	msg -> mhdr.msg_id = MSQTXR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqtxr) - sizeof(MSGHDR);
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> qtx_indx = index ;
	msg -> qtx_set = as_set ;
	msg -> qtx_state = fromstate ;
}

static char *SccsId = "@(#)q_txrep.c	1.7\t2/21/85" ;
