#include <gks/gks_types.h>
#include <gks/message.h>
#include <gks/qpixdim.h>

#include <gks/trace.h>

#include "wsinfo.h"

GKSERR
q_px_dim(wkid, p, q, errno, dx, dy)
WKID wkid ;
WCPT *p, *q ;
GKSERR *errno ;
int *dx, *dy ;
{
	struct msqpixdim *msg ;
	struct msqpixdim *reply ;
	static char *fname = "q_px_dim" ;
	WSINFO ws ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	
	if(wkid <= 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}

	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		return ;
	}
/*
 * deliver "inquire pixel array dimensions" message
 */
	msg = (struct msqpixdim *)_allocmsg(sizeof(struct msqpixdim)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	qpixdimmsg(msg, WsGetpid(ws), p, q) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqpixdim *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	*dx = reply -> qpd_x ;
	*dy = reply -> qpd_y ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, (%.2f, %.2f), (%.2f, %.2f), ... %d, %d)\n",
			fname, wkid,  p -> wc_x, p -> wc_y, q -> wc_x, q -> wc_y,
			*dx, *dy) ;
#endif
	_freemsg(reply) ;
	*errno = 0 ;
}

static
qpixdimmsg(msg, pid, p, q)
struct msqpixdim *msg ;
PID pid ;
WCPT *p, *q ;
{
	msg -> mhdr.msg_id = MSQPIXDIM ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqpixdim) - sizeof(MSGHDR) ;
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	_wc2ndc(p, &(msg -> qpd_p)) ;
	_wc2ndc(q, &(msg -> qpd_q)) ;
}

static char *SccsId = "@(#)q_px_dim.c	1.5\t2/21/85" ;
