#include <gks/gks_types.h>
#include <gks/gks_structs.h>
#include <gks/message.h>
#include <gks/qcorep.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern struct gksstate Gksstate ;

/*
 * inquire color representation
 */
VOID
q_ws_cor(wkid, index, as_set, errno, red, green, blue)
WKID wkid ;
int index ;
BOOL as_set ;
GKSERR *errno ;
REAL *red ;
REAL *blue ;
REAL *green ;
{
	static char *fname = "q_ws_cor" ;
	WSINFO ws ;
	struct msqcor *msg ;
	struct msqcor *reply ;

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 7 ;
		return ;
	}
	if(wkid == 0)
	{
		*errno = 20 ;
		return ;
	}

	ws = WsId2info(wkid) ;
	if(ws == NULL)
	{
		*errno = 25 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_MI)
	{
		*errno = 33 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_INPUT)
	{
		*errno = 35 ;
		return ;
	}
	if(WsGetcat(ws) == WSC_WISS)
	{
		*errno = 36 ;
		return ;
	}

	msg = (struct msqcor *)_allocmsg(sizeof(struct msqcor)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	cormsg(msg, WsGetpid(ws), index, as_set, TRUE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqcor *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;


		case 1:
			*errno = 86 ;
			_freemsg(reply) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*red = reply -> qco_corep.cor_red ;
	*green = reply -> qco_corep.cor_green ;
	*blue = reply -> qco_corep.cor_blue ;
	_freemsg(reply) ;

#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %d, %f, %f, %f)\n", fname, wkid, index, as_set,
					*errno, *red, *green, *blue) ;
#endif
}

/*
 * inquire default color representation
 *
 *	14 july 86, wrf		workstation MUST be open
 */
VOID
q_wd_cor(wktype, index, errno, red, green, blue)
WSTYPE wktype ;
int index ;
GKSERR *errno ;
REAL *red ;
REAL *blue ;
REAL *green ;
{
	static char *fname = "q_wd_cor" ;
	WSINFO ws ;
	struct msqcor *msg ;
	struct msqcor *reply ;
	BOOL must_close = FALSE ;

	if(!Gksckstate(GS_GKOP | GS_WSOP | GS_WSAC | GS_SGOP))
	{
		*errno = 8 ;
		return ;
	}
/*
 * see if workstation of specified type is already open.
 */
	for(ws = WsFirst(); ws != NULL; ws = WsNext())
		if(WsGettype(ws) == wktype)
			break ;

	if (ws == NULL)
		{
		*errno = 25;
		return;
		}

/***********************************************************************
	if(ws == NULL)		/* quel dommage!
						 * must open workstation, ask, and close it.
						 */
/***********************************************************************
	{
		if(open_ws(0xffff, "", wktype) != 0)
		{
			*errno = 22 ;
			return ;
		}
		ws = WsId2info(0xffff) ;
		must_close = TRUE ;
	}
***********************************************************************/
	if((WsGetcat(ws) != WSC_OUTPUT) && (WsGetcat(ws) != WSC_OUTIN))
	{
		*errno = 39 ;
		if(must_close)
			close_ws(0xffff) ;
		return ;
	}

	msg = (struct msqcor *)_allocmsg(sizeof(struct msqcor)) ;
	if(msg == NULL)
	{
		*errno = 904 ;
		return ;
	}
	cormsg(msg, WsGetpid(ws), index, TRUE, FALSE) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	reply = (struct msqcor *)_recvmsg(WsGetpid(ws)) ;
	if(reply == NULL)
	{
		*errno = WsNomsg() ;
		return ;
	}
	switch(reply -> mhdr.msg_reply)
	{
		case 0:
			*errno = 0 ;
			break ;

		case 1:
			*errno = 86 ;
			_freemsg(reply) ;
			if(must_close)
				close_ws(0xffff) ;
			return ;

		default:
			Gksout("internal error: unexpected reply to %s\n", fname) ;
			*errno = 0 ;
	}

	*red = reply -> qco_corep.cor_red ;
	*green = reply -> qco_corep.cor_green ;
	*blue = reply -> qco_corep.cor_blue ;
	_freemsg(reply) ;

	if(must_close)
		close_ws(0xffff) ;
#ifdef TRACE
	if(Gksdebug & DB_INQUIRE)
		Gksout("%s(%d, %d, %d, %f, %f, %f)\n", fname, wktype, index,
					*errno, *red, *green, *blue) ;
#endif
}

static
cormsg(msg, pid, index, as_set, fromstate)
struct msqcor *msg ;
PID pid ;
int index ;
BOOL as_set ;
BOOL fromstate ;
{
	msg -> mhdr.msg_id = MSQCOR ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msqcor) - sizeof(MSGHDR);
	msg -> mhdr.msg_ack = TRUE ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> qco_indx = index ;
	msg -> qco_set = as_set ;
	msg -> qco_state = fromstate ;
}

static char *SccsId = "@(#)q_corep.c	1.7\t2/21/85" ;
