#include <gks/gks_types.h>
#include <gks/message.h>
#include <gks/gks_structs.h>
#include <gks/inputmsg.h>

#include <gks/trace.h>

#include "wsinfo.h"

extern BOOL _GksAck;


/*
 * initialize valuator
 */

GKSERR
ini_val(wkid, devno, initval, prompt, xmin, xmax, ymin, ymax, datarec)
WKID wkid ;
int  devno ;
REAL initval ;
int  prompt ;
DC   xmin,
     xmax,
     ymin,
     ymax ;
struct i_valdata *datarec ;
{
	int res = 0 ;
	struct msinpinit *msg ;
	MSGHDR *reply ;
	WSINFO ws ;
	static char *fname = "ini_val" ;

#ifdef TRACE
	if(Gksdebug & DB_INPUT)
		Gksout("ini_val(%d, %d, %8.3f %d\n\t%8.3f, %8.3f, %8.3f, %8.3f)\n",
			wkid, devno, initval, prompt, xmin, xmax, ymin, ymax) ;
#endif

	if(!Gksckstate(GS_WSOP | GS_WSAC | GS_SGOP))
		return(err_hand(7, fname)) ;

	if(wkid == 0)
		return(err_hand(20, fname)) ;

	if((xmin >= xmax) || (ymin >= ymax))
		return(err_hand(51, fname)) ;

/*
 * deliver "initialize valuator" message
 */

	ws = WsId2info(wkid) ;
	if(ws == NULL)
		return(err_hand(25, fname)) ;

	if((WsGetcat(ws) != WSC_INPUT) && (WsGetcat(ws) != WSC_OUTIN))
		return(err_hand(38, fname)) ;

	msg = (struct msinpinit *)_allocmsg(sizeof(struct msinpinit) + 
		sizeof(struct i_valdata)) ;
	if(msg == NULL)
		return(err_hand(904, fname)) ;
	inpinitmsg(msg, WsGetpid(ws), devno, initval, prompt, xmin, xmax, ymin, ymax, datarec) ;
	_sendmsg((char *)msg) ;
/*
 * wait for reply
 */
	if (_GksAck)
		{
		reply = (MSGHDR *)_recvmsg(WsGetpid(ws)) ;
		if(reply == NULL)
			return (err_hand(WsNomsg(), fname));
		switch(reply -> msg_reply)
			{
		case 0:		/* success */
			res = 0 ;
			break ;

		case 1:		/* device not present on workstation */
			res = 140 ;
			break ;

		case 2:		/* device not in request mode */
			res = 141 ;
			break ;

		case 3:		/* echo type not supported */
			res = 144 ;
			break ;

		case 4:		/* echo area outside display surface */
			res = 145 ;
			break ;

		case 5:		/* contents of data record invalid */
			res = 146 ;
			break ;

		case 6:		/* initial value is invalid */
			res = 152 ;
			break ;

		default:
			Gksout("gks internal error: bad reply to ini_val.\n") ;
			Gksout("\twkid = %d, reply = %d\n", wkid, reply -> msg_reply) ;
			res = 0 ;
			}
		_freemsg(reply) ;
		}

	if(res != 0)
		return(err_hand(res, fname)) ;
	return(0) ;
}

static inpinitmsg(msg,pid, devno, initval, prompt, xmin, xmax, ymin, ymax, datarec)
struct msinpinit *msg ;
PID pid ;
int devno ;
REAL initval ;
int prompt ;
WC  xmin,
	xmax,
	ymin,
	ymax ;
struct i_valdata *datarec ;
{
	msg -> mhdr.msg_id = MSINPINI ;
	msg -> mhdr.msg_to = pid ;
	msg -> mhdr.msg_length = sizeof(struct msinpinit) + sizeof(struct i_valdata)
			- sizeof(int) - sizeof(MSGHDR) ;
	msg -> mhdr.msg_ack = _GksAck ;
	msg -> mhdr.msg_reply = 0 ;
	msg -> inpcls = VALUATOR ;
	msg -> inpdevno = devno ;
	msg -> initun.inpt_val = initval ;
	msg -> inpprmpt = prompt ;
	msg -> echo_xmin = xmin ;
	msg -> echo_xmax = xmax ;
	msg -> echo_ymin = ymin ;
	msg -> echo_ymax = ymax ;
	cpybuf((struct i_valdata *)(msg -> datarec), datarec,
			sizeof(struct i_valdata));
}

static char *SccsId = "@(#)ini_val.c	1.5\t2/27/85" ;
