/*
 *
 *	Revision History:
 *
 *		29 aug 86	wrf	sw# 49
 *			added read and write to DLM
 */
#include "gks_types.h"
#include "gks_structs.h"
#include "escapes.h"


/*
 * escape function
 */

GKSERR	escape(escid, data)
	register ESCAPE_ID escid;
	register char *data;
{
	register int retval = 0;

	switch (escid)
		{
#if 0
	case ESCTRACE:
		Gksdebug = (unsigned short) data;
		break;

	case ESCPSEL:		/* plane select */
		return (plsel(fname, data));

	case ESCVSW:		/* video switch */
		return (viewsw(fname, data));

	case ESCZOOMPAN:	/* zoom and pan */
		ws = WsId2info(((struct esczoompan *) data)->zp_wkid);
		if (ws == NULL)
			return (err_hand(25, fname));

		msg = (struct msescape *) _allocmsg(sizeof(struct msescape) +
							sizeof(struct esczoompan) - sizeof(int));
		if (msg == NULL)
			return (err_hand(904, fname));
		zpmsg(msg, WsGetpid(ws), escid, data);
		_sendmsg((char *) msg);
		if (_GksAck)
			{
			reply = (struct msescape *) _recvmsg(WsGetpid(ws));
			if (reply == NULL)
				return (err_hand(WsNomsg(), fname));
			_freemsg(reply);
			}
		break;

	case ESCDRAG:		/* drag list of segments */
			{
			struct escdrag *p = (struct escdrag *) data;
			struct escrpdrag *q;
			int	n;

			ws = WsId2info(p->dr_wkid);
			if (ws == NULL)
				return (err_hand(25, fname));

			n = p->dr_nsegs;
			msg = (struct msescape *) _allocmsg(sizeof(struct msescape) +
								sizeof(struct escdrag) + (n - 1) * sizeof(SEGNAME)
								- sizeof(int));
			if (msg == NULL)
				return (err_hand(904, fname));
			dragmsg(msg, WsGetpid(ws), escid, data);
			_sendmsg((char *) msg);
			reply = (struct msescape *) _recvmsg(WsGetpid(ws));
			if (reply == NULL)
				return (err_hand(WsNomsg(), fname));
			switch (reply->mhdr.msg_reply)
				{
			case 0:/* success */

				q = (struct escrpdrag *) (reply->esc_data);
				segadjustxy(p->dr_nsegs, p->dr_segs,
						q->dr_delx, q->dr_dely);
				break;

			case 1:
				retval = 141;	/* not in REQUEST mode */
				break;

			case 2:
				retval = 140;	/* device not present */
				break;

			case 3:/* device not ready */
				retval = 1015;
				break;

			case 4:
				retval = 25;	/* wrong state */
				break;

			default:
				Gksout("internal error: unexpected reply from ESCDRAG\n");
				}

			_freemsg(reply);
			break;
			}

	case ESCRDRW:		/* extended redraw */
		return (extrdrw(fname, data));
#endif

	case ESCCXPSEG: /* cx1500 "put segment" function */
			{
			SEGNAME segid;
			char   *filename;

			segid = ((struct esccxpseg *) data)->cxps_id;
			filename = ((struct esccxpseg *) data)->cxps_pname;
			return _putseg(segid, filename);
#if 0
/*
 *	putseg escape function
 */
			struct esccxpseg
				{
				SEGNAME cxps_id;	/* name of segment to be created */
				char	cxps_pname[MAXPATH + 1];	/* file containing segment image */
				};
#endif
			}

	case ESCCXGSEG: /* cx1500 "get segment" function */
#if 0
		struct esccxgseg
			{
			WKID	cxgs_wkid;	/* workstation on which segment resides */
			SEGNAME cxgs_id;	/* name of segment */
			char	cxgs_pname[MAXPATH + 1];	/* file to receive segment image */
			};
#endif
			{
			int	wkid;
			int	segid;
			char   *filename;
			wkid = ((struct esccxgseg *) data)->cxgs_wkid;
			filename = ((struct esccxgseg *) data)->cxgs_pname;
			segid = ((struct esccxgseg *) data)->cxgs_id;
			return _getseg(wkid, segid, filename);
			}

#if 0
	case ESCCXAUXV: /* cx1500 auxiliary video on/off */
		ws = WsId2info(((struct esccxauxv *) data)->cxaux_wkid);
		if (ws == NULL)
			return (err_hand(25, fname));

		if (!WsIsCx(ws))
			return (err_hand(181, fname));
		msg = (struct msescape *) _allocmsg(sizeof(struct msescape) +
							sizeof(struct esccxauxv) - sizeof(int));
		if (msg == NULL)
			return (err_hand(904, fname));
		cxauxmsg(msg, WsGetpid(ws), escid, data);
		_sendmsg((char *) msg);
		if (_GksAck)
			{
			reply = (struct msescape *) _recvmsg(WsGetpid(ws));
			if (reply == NULL)
				return (err_hand(WsNomsg(), fname));
			_freemsg(reply);
			}
		break;

	case ESCCXHW:
		ws = WsId2info(((struct esccxhw *) data)->cxhw_wkid);
		if (ws == NULL)
			return (err_hand(25, fname));

		if (!WsIsCx(ws))
			return (err_hand(181, fname));

		msg = (struct msescape *) _allocmsg(sizeof(struct msescape) +
							sizeof(struct esccxhw) - sizeof(int));
		if (msg == NULL)
			return (err_hand(904, fname));
		cxhwmsg(msg, WsGetpid(ws), escid, data);
		_sendmsg((char *) msg);
		reply = (struct msescape *) _recvmsg(WsGetpid(ws));
		if (reply == NULL)
			return (err_hand(WsNomsg(), fname));
		cpybuf(data, (char *) reply->esc_data, sizeof(struct esccxhw));
		_freemsg(reply);
		break;

	case ESCCXDLPOP:	/* put DLP opcodes into segment */
		return (cxdlpop(fname, data));
		break;

	case ESCCXMLOAD:	/* load microcode */
			{
			int	addr, maxinst, n;
			char   *inst;

			ws = WsId2info(((struct esccxmload *) data)->cxmld_wkid);
			if (ws == NULL)
				return (err_hand(25, fname));

			if (!WsIsCx(ws))
				return (err_hand(181, fname));

			for (inst = (char *) ((struct esccxmload *) data)->cxmld_i,
				 addr = ((struct esccxmload *) data)->cxmld_a,
				 n = ((struct esccxmload *) data)->cxmld_n;
				 n > 0; n -= maxinst)
				{
				maxinst = (n < 800) ? n : 800;
				msg = (struct msescape *) _allocmsg(sizeof(struct msescape) +
									sizeof(struct esccxmload) + (maxinst - 1) *
									sizeof(((struct esccxmload *) data)->cxmld_i)
									- sizeof(int));

				if (msg == NULL)
					return (err_hand(904, fname));

				cxmloadmsg(msg, WsGetpid(ws), escid, inst, addr, maxinst);
				_sendmsg((char *) msg);
				if (_GksAck)
					{
					reply = (struct msescape *) _recvmsg(WsGetpid(ws));
					if (reply == NULL)
						return (err_hand(WsNomsg(), fname));
					switch (reply->mhdr.msg_reply)
						{
					case 0:
						break;

					case 1: /* bad load address */
						retval = 1006;
						break;

					case 2: /* couldn't load microcode */
						retval = 1007;
						break;
						}

					_freemsg(reply);
					}

				if (retval != 0)
					break;

				inst = inst + maxinst *
					sizeof(((struct esccxmload *) data)->cxmld_i);
				addr += maxinst;
				}
			}

		break;


	case ESCCXFNTLD:	/* load font */
		break;


	case ESCLDEF:		/* define linestyle */
		return (escldef(fname, data));

	case ESCLDCLU:		/* load color lookup table */
		return (escldclu(fname, data));

	case ESCCLIP:		/* change clip rectangles */
		return (escsgclip(fname, data));

	case ESCSGDRW:		/* redraw segments */
		return (escsgdrw(fname, data));

	case ESCERASE:		/* erase screen */
		return (escerase(fname, data));

	case ESCPICK:		/* extended pick */
		return (escpick(fname, data));

	case ESCBRATE:		/* set blink rate */
		return (escbrate(fname, data));

	case ESCBTYPE:		/* set blink type */
		return (escbtype(fname, data));

	case ESCBCTBL:		/* set blink color table */
		return (escbctbl(fname, data));

	case ESCBLINK:		/* blink */
		return (escblink(fname, data));

	case ESCCXMDEF: /* define polymarker */
		return (esccxmdef(fname, data));

	case ESCCXHDEF: /* define hatch patterns */
		return (esccxhdef(fname, data));

	case ESCCXRIO:		/* remote I/O */
		return (esccxrio(fname, data));

	case ESCCXINFG: /* initialize frame grabber */
		return (esccxinfg(fname, data));

	case ESCCXLDCLD:	/* load color lookdown table */
		return (esccxldcld(fname, data));

	case ESCCXHCM:		/* set highlight color mask */
		return (esccxhcm(fname, data));

	case ESCCXMEM:		/* alloc/free DLM */
		return (esccxmem(fname, data));

	case ESCCXRDLM: /* read from DLM */
		return (escdlmrw(fname, data, ESCCXRDLM));

	case ESCCXWDLM: /* write to DLM */
		return (escdlmrw(fname, data, ESCCXWDLM));

#endif
	default:
		printf("ESCAPE Not supported yet!\n");
		}

	return (0);

}
