/*
 * SCCS info --- @(#)psipcfg.h	1.5   12/1/94
 */

/*
 * Copyright (c) 1993, 1994 by Castelle
 * The use of this software is restricted to Castelle customers.
 *
 *
 * THIS SOFTWARE IS PROVIDED BY THE CASTELLE ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CASTELLE BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	psipcfg.h	- for dynamic print server configuration
 *
 */

#ifndef _PSIPCFG_H_
#define	_PSIPCFG_H_

#ifdef	BCOPY
/* use socket library bcopy/bzero */
#define	memcpy(d,s,l)	bcopy(s,d,l)
#define	memset(d,0,l)	bzero(d,l)
#endif

#define	PSIPCFG_PORT	(u_short) 1111

/* print server configuration block */

struct	psipcfg {
	u_char	serno[8];
	u_char	cfgop;
#define	PSIPCFG_NOOP		0
#define	PSIPCFG_ADDRESS		1
#define	PSIPCFG_BROADCAST	2
#define	PSIPCFG_SUBNETMASK	3
#define	PSIPCFG_POINT2POINT	4
#define	PSIPCFG_GATEWAY		5
#define	PSIPCFG_OPTIONS		6
#define	PSIPCFG_SETPORTCFG	8
#define	PSIPCFG_GETPORTCFG	9
#define	PSIPCFG_BAUDRATE	10
#define	PSIPCFG_STOPBITS	11
#define	PSIPCFG_DATABITS	12
#define	PSIPCFG_FLOWCNTL	13
#define	PSIPCFG_PARITY		14
#define	PSIPCFG_RESET		15
#define	PSIPCFG_SETDEFAULT	16
#define	PSIPCFG_GETMEMORY	17
#define	PSIPCFG_SETMEMORY	18
#define	PSIPCFG_MEMQUERY	19
#define	PSIPCFG_SETFUNC		20
#define	PSIPCFG_PASPEED		21
#define	PSIPCFG_SHOW		22
#define	PSIPCFG_FINDSN		23
#define	PSIPCFG_SETPORTLAN	24
#define	PSIPCFG_GETPORTLAN	25
#define	PSIPCFG_SETPORTRPT	26
#define	PSIPCFG_GETPORTRPT	27
#define	PSIPCFG_CLBUF     	28
#define	PSIPCFG_INIT     	29
#define PSIPCFG_SETFSNAME       30
#define PSIPCFG_SETPOLLING      31
#define PSIPCFG_SETLPNAME       32
#define	PSIPCFG_TERM		0xff
	u_char	status;
	u_short	cfglen;
	u_char	cfgbuf[128];
};

/* network ordered values - mimics struct ipx_eeprom for client apps */

struct	tcpipcfg {
	u_long	ifaddr;			/* Internet address */
	u_long	broadcast;		/* broadcast address */
	u_long	subnetmask;		/* subnet mask */
	u_long	pt2pt;			/* point-to-point */
	u_long	gate0;			/* default gateway */
	u_long	dst1, gate1;	/* static route 1 */
	u_long	dst2, gate2;	/* static route 2 */
	u_char	soft_tick;		/* clock loop for protocol timer task */
	u_char	small;			/* no. of small mbufs, 0 for default */
	u_char	large;			/* no. of large mbufs, 0 for default */
	u_char	option;			/* various TCP/IPX options */
    u_char  baud_rate[2];   /* 1 for 300
                               2 for 600
                               3 for 1200
                               4 for 2400
                               5 for 4800
                               6 for 9600
                               7 for 19200
                               8 for 38400 */
    u_char  bits[2];
    u_char  flow_cntl[2];   /* 1 for XON
                               2 for XOFF  */
#define	TCPIPX_NULL			0
#define	TCPIPX_TRAILERS		1
#define	TCPIPX_NOTCPCKSUM	2
#define	TCPIPX_NOUDPCKSUM	4
#define	TCPIPX_NOARP		8
};

#define PRINT_REPORT	 0x80
#define NO_PRINT_REPORT	 0x40
#define PRINT_ASCII		 0x00
#define PRINT_PS		 0x01

typedef	struct	Sconfig_data {
	u_char	sname[48];
	u_char	sdata[16];
}
Sconfig_data;

typedef struct	ipx_eeprom {
	unsigned long ifaddr;		/* Internet address, in host order */
	unsigned long broadcast;	/* broadcast address (if any) */
	unsigned long subnetmask;	/* subnet mask (if any) */
	unsigned long pt2pt;		/* ip destination - point-to-point (if any) */
	unsigned long gate0;		/* ip default gateway */

	unsigned long dst1;
	unsigned long gate1;		/* static route 1 */
	unsigned long dst2;
	unsigned long gate2;		/* static route 2 */

	u_char	soft_tick;			/* clock loop for protocol timer task */
	u_char	small;				/* no. of small mbufs, 0 for default */
	u_char	large;				/* no. of large mbufs, 0 for default */
	u_char	option;				/* various options */
    u_char  baud_rate[2];   /* 1 for 300
                               2 for 600
                               3 for 1200
                               4 for 2400
                               5 for 4800
                               6 for 9600
                               7 for 19200
                               8 for 38400 */
    u_char  bits[2];
    u_char  flow_cntl[2];   /* 1 for XON
                               2 for XOFF  */
#define	IPX_NULL		0
#define	IPX_TRAILERS	1
#define	IPX_NOTCPCKSUM	2
#define	IPX_NOUDPCKSUM	4
#define	IPX_NOARP		8
}
ipx_eeprom;

extern void showSyntax();
extern int print_hex();
extern int check_ip_string();
extern int check_baud_string();
extern int check_dbits_string();
extern int check_sbits_string();
extern int check_fcntl_string();
extern int check_parity_string();

#endif /* DO NOT ADD ANYTHING BEYOND THIS LINE */
